package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link PreferredSchedulingTerm} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractPreferredSchedulingTermAssert<S extends AbstractPreferredSchedulingTermAssert<S, A>, A extends PreferredSchedulingTerm> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractPreferredSchedulingTermAssert}</code> to make assertions on actual PreferredSchedulingTerm.
   * @param actual the PreferredSchedulingTerm we want to make assertions on.
   */
  protected AbstractPreferredSchedulingTermAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual PreferredSchedulingTerm we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property preference so that assertions can be done on it
   */
  public NodeSelectorTermAssert preference()  {
    // check that actual PreferredSchedulingTerm we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (NodeSelectorTermAssert) assertThat(actual.getPreference()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "preference"));
  }


  /**
   * Verifies that the actual PreferredSchedulingTerm's weight is equal to the given one.
   * @param weight the given weight to compare the actual PreferredSchedulingTerm's weight to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PreferredSchedulingTerm's weight is not equal to the given one.
   */
  public S hasWeight(Integer weight) {
    // check that actual PreferredSchedulingTerm we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting weight of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualWeight = actual.getWeight();
    if (!Objects.areEqual(actualWeight, weight)) {
      failWithMessage(assertjErrorMessage, actual, weight, actualWeight);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
