package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link Preferences} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractPreferencesAssert<S extends AbstractPreferencesAssert<S, A>, A extends Preferences> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractPreferencesAssert}</code> to make assertions on actual Preferences.
   * @param actual the Preferences we want to make assertions on.
   */
  protected AbstractPreferencesAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual Preferences we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property colors so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert colors()  {
    // check that actual Preferences we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getColors()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "colors"));
  }


  /**
   * Navigates to the property extensions so that assertions can be done on it
   */
  public NavigationListAssert<NamedExtension, NamedExtensionAssert> extensions()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<NamedExtension, NamedExtensionAssert> assertFactory = new AssertFactory<NamedExtension, NamedExtensionAssert>() {
      public NamedExtensionAssert createAssert(NamedExtension t) {
        return (NamedExtensionAssert) assertThat(t);
      }
    };
    NavigationListAssert<NamedExtension, NamedExtensionAssert> answer = new NavigationListAssert<NamedExtension, NamedExtensionAssert>(actual.getExtensions(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "extensions"));
    return answer;
  }


}
