package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link PodStatus} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractPodStatusAssert<S extends AbstractPodStatusAssert<S, A>, A extends PodStatus> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractPodStatusAssert}</code> to make assertions on actual PodStatus.
   * @param actual the PodStatus we want to make assertions on.
   */
  protected AbstractPodStatusAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual PodStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property conditions so that assertions can be done on it
   */
  public NavigationListAssert<PodCondition, PodConditionAssert> conditions()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<PodCondition, PodConditionAssert> assertFactory = new AssertFactory<PodCondition, PodConditionAssert>() {
      public PodConditionAssert createAssert(PodCondition t) {
        return (PodConditionAssert) assertThat(t);
      }
    };
    NavigationListAssert<PodCondition, PodConditionAssert> answer = new NavigationListAssert<PodCondition, PodConditionAssert>(actual.getConditions(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "conditions"));
    return answer;
  }


  /**
   * Navigates to the property containerStatuses so that assertions can be done on it
   */
  public NavigationListAssert<ContainerStatus, ContainerStatusAssert> containerStatuses()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<ContainerStatus, ContainerStatusAssert> assertFactory = new AssertFactory<ContainerStatus, ContainerStatusAssert>() {
      public ContainerStatusAssert createAssert(ContainerStatus t) {
        return (ContainerStatusAssert) assertThat(t);
      }
    };
    NavigationListAssert<ContainerStatus, ContainerStatusAssert> answer = new NavigationListAssert<ContainerStatus, ContainerStatusAssert>(actual.getContainerStatuses(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "containerStatuses"));
    return answer;
  }


  /**
   * Navigates to the property ephemeralContainerStatuses so that assertions can be done on it
   */
  public NavigationListAssert<ContainerStatus, ContainerStatusAssert> ephemeralContainerStatuses()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<ContainerStatus, ContainerStatusAssert> assertFactory = new AssertFactory<ContainerStatus, ContainerStatusAssert>() {
      public ContainerStatusAssert createAssert(ContainerStatus t) {
        return (ContainerStatusAssert) assertThat(t);
      }
    };
    NavigationListAssert<ContainerStatus, ContainerStatusAssert> answer = new NavigationListAssert<ContainerStatus, ContainerStatusAssert>(actual.getEphemeralContainerStatuses(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "ephemeralContainerStatuses"));
    return answer;
  }


  /**
   * Navigates to the property hostIP so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert hostIP()  {
    // check that actual PodStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getHostIP()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "hostIP"));
  }


  /**
   * Navigates to the property initContainerStatuses so that assertions can be done on it
   */
  public NavigationListAssert<ContainerStatus, ContainerStatusAssert> initContainerStatuses()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<ContainerStatus, ContainerStatusAssert> assertFactory = new AssertFactory<ContainerStatus, ContainerStatusAssert>() {
      public ContainerStatusAssert createAssert(ContainerStatus t) {
        return (ContainerStatusAssert) assertThat(t);
      }
    };
    NavigationListAssert<ContainerStatus, ContainerStatusAssert> answer = new NavigationListAssert<ContainerStatus, ContainerStatusAssert>(actual.getInitContainerStatuses(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "initContainerStatuses"));
    return answer;
  }


  /**
   * Navigates to the property message so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert message()  {
    // check that actual PodStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getMessage()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "message"));
  }


  /**
   * Navigates to the property nominatedNodeName so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert nominatedNodeName()  {
    // check that actual PodStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getNominatedNodeName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "nominatedNodeName"));
  }


  /**
   * Navigates to the property phase so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert phase()  {
    // check that actual PodStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getPhase()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "phase"));
  }


  /**
   * Navigates to the property podIP so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert podIP()  {
    // check that actual PodStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getPodIP()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "podIP"));
  }


  /**
   * Navigates to the property podIPs so that assertions can be done on it
   */
  public NavigationListAssert<PodIP, PodIPAssert> podIPs()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<PodIP, PodIPAssert> assertFactory = new AssertFactory<PodIP, PodIPAssert>() {
      public PodIPAssert createAssert(PodIP t) {
        return (PodIPAssert) assertThat(t);
      }
    };
    NavigationListAssert<PodIP, PodIPAssert> answer = new NavigationListAssert<PodIP, PodIPAssert>(actual.getPodIPs(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "podIPs"));
    return answer;
  }


  /**
   * Navigates to the property qosClass so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert qosClass()  {
    // check that actual PodStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getQosClass()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "qosClass"));
  }


  /**
   * Navigates to the property reason so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert reason()  {
    // check that actual PodStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getReason()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "reason"));
  }


  /**
   * Navigates to the property startTime so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert startTime()  {
    // check that actual PodStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getStartTime()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "startTime"));
  }


}
