package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link PodDNSConfig} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractPodDNSConfigAssert<S extends AbstractPodDNSConfigAssert<S, A>, A extends PodDNSConfig> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractPodDNSConfigAssert}</code> to make assertions on actual PodDNSConfig.
   * @param actual the PodDNSConfig we want to make assertions on.
   */
  protected AbstractPodDNSConfigAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual PodDNSConfig we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property nameservers so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> nameservers()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getNameservers(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "nameservers"));
    return answer;
  }


  /**
   * Navigates to the property options so that assertions can be done on it
   */
  public NavigationListAssert<PodDNSConfigOption, PodDNSConfigOptionAssert> options()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<PodDNSConfigOption, PodDNSConfigOptionAssert> assertFactory = new AssertFactory<PodDNSConfigOption, PodDNSConfigOptionAssert>() {
      public PodDNSConfigOptionAssert createAssert(PodDNSConfigOption t) {
        return (PodDNSConfigOptionAssert) assertThat(t);
      }
    };
    NavigationListAssert<PodDNSConfigOption, PodDNSConfigOptionAssert> answer = new NavigationListAssert<PodDNSConfigOption, PodDNSConfigOptionAssert>(actual.getOptions(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "options"));
    return answer;
  }


  /**
   * Navigates to the property searches so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> searches()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getSearches(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "searches"));
    return answer;
  }


}
