package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link PodAffinityTerm} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractPodAffinityTermAssert<S extends AbstractPodAffinityTermAssert<S, A>, A extends PodAffinityTerm> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractPodAffinityTermAssert}</code> to make assertions on actual PodAffinityTerm.
   * @param actual the PodAffinityTerm we want to make assertions on.
   */
  protected AbstractPodAffinityTermAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual PodAffinityTerm we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property labelSelector so that assertions can be done on it
   */
  public LabelSelectorAssert labelSelector()  {
    // check that actual PodAffinityTerm we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (LabelSelectorAssert) assertThat(actual.getLabelSelector()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "labelSelector"));
  }


  /**
   * Navigates to the property namespaces so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> namespaces()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getNamespaces(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "namespaces"));
    return answer;
  }


  /**
   * Navigates to the property topologyKey so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert topologyKey()  {
    // check that actual PodAffinityTerm we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getTopologyKey()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "topologyKey"));
  }


}
