package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link PersistentVolumeSpec} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractPersistentVolumeSpecAssert<S extends AbstractPersistentVolumeSpecAssert<S, A>, A extends PersistentVolumeSpec> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractPersistentVolumeSpecAssert}</code> to make assertions on actual PersistentVolumeSpec.
   * @param actual the PersistentVolumeSpec we want to make assertions on.
   */
  protected AbstractPersistentVolumeSpecAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property accessModes so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> accessModes()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getAccessModes(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "accessModes"));
    return answer;
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual PersistentVolumeSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property awsElasticBlockStore so that assertions can be done on it
   */
  public AWSElasticBlockStoreVolumeSourceAssert awsElasticBlockStore()  {
    // check that actual PersistentVolumeSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (AWSElasticBlockStoreVolumeSourceAssert) assertThat(actual.getAwsElasticBlockStore()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "awsElasticBlockStore"));
  }


  /**
   * Navigates to the property azureDisk so that assertions can be done on it
   */
  public AzureDiskVolumeSourceAssert azureDisk()  {
    // check that actual PersistentVolumeSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (AzureDiskVolumeSourceAssert) assertThat(actual.getAzureDisk()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "azureDisk"));
  }


  /**
   * Navigates to the property azureFile so that assertions can be done on it
   */
  public AzureFilePersistentVolumeSourceAssert azureFile()  {
    // check that actual PersistentVolumeSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (AzureFilePersistentVolumeSourceAssert) assertThat(actual.getAzureFile()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "azureFile"));
  }


  /**
   * Navigates to the property capacity so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert capacity()  {
    // check that actual PersistentVolumeSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getCapacity()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "capacity"));
  }


  /**
   * Navigates to the property cephfs so that assertions can be done on it
   */
  public CephFSPersistentVolumeSourceAssert cephfs()  {
    // check that actual PersistentVolumeSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (CephFSPersistentVolumeSourceAssert) assertThat(actual.getCephfs()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "cephfs"));
  }


  /**
   * Navigates to the property cinder so that assertions can be done on it
   */
  public CinderPersistentVolumeSourceAssert cinder()  {
    // check that actual PersistentVolumeSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (CinderPersistentVolumeSourceAssert) assertThat(actual.getCinder()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "cinder"));
  }


  /**
   * Navigates to the property claimRef so that assertions can be done on it
   */
  public ObjectReferenceAssert claimRef()  {
    // check that actual PersistentVolumeSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ObjectReferenceAssert) assertThat(actual.getClaimRef()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "claimRef"));
  }


  /**
   * Navigates to the property csi so that assertions can be done on it
   */
  public CSIPersistentVolumeSourceAssert csi()  {
    // check that actual PersistentVolumeSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (CSIPersistentVolumeSourceAssert) assertThat(actual.getCsi()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "csi"));
  }


  /**
   * Navigates to the property fc so that assertions can be done on it
   */
  public FCVolumeSourceAssert fc()  {
    // check that actual PersistentVolumeSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (FCVolumeSourceAssert) assertThat(actual.getFc()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "fc"));
  }


  /**
   * Navigates to the property flexVolume so that assertions can be done on it
   */
  public FlexPersistentVolumeSourceAssert flexVolume()  {
    // check that actual PersistentVolumeSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (FlexPersistentVolumeSourceAssert) assertThat(actual.getFlexVolume()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "flexVolume"));
  }


  /**
   * Navigates to the property flocker so that assertions can be done on it
   */
  public FlockerVolumeSourceAssert flocker()  {
    // check that actual PersistentVolumeSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (FlockerVolumeSourceAssert) assertThat(actual.getFlocker()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "flocker"));
  }


  /**
   * Navigates to the property gcePersistentDisk so that assertions can be done on it
   */
  public GCEPersistentDiskVolumeSourceAssert gcePersistentDisk()  {
    // check that actual PersistentVolumeSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (GCEPersistentDiskVolumeSourceAssert) assertThat(actual.getGcePersistentDisk()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "gcePersistentDisk"));
  }


  /**
   * Navigates to the property glusterfs so that assertions can be done on it
   */
  public GlusterfsPersistentVolumeSourceAssert glusterfs()  {
    // check that actual PersistentVolumeSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (GlusterfsPersistentVolumeSourceAssert) assertThat(actual.getGlusterfs()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "glusterfs"));
  }


  /**
   * Navigates to the property hostPath so that assertions can be done on it
   */
  public HostPathVolumeSourceAssert hostPath()  {
    // check that actual PersistentVolumeSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (HostPathVolumeSourceAssert) assertThat(actual.getHostPath()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "hostPath"));
  }


  /**
   * Navigates to the property iscsi so that assertions can be done on it
   */
  public ISCSIPersistentVolumeSourceAssert iscsi()  {
    // check that actual PersistentVolumeSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ISCSIPersistentVolumeSourceAssert) assertThat(actual.getIscsi()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "iscsi"));
  }


  /**
   * Navigates to the property local so that assertions can be done on it
   */
  public LocalVolumeSourceAssert local()  {
    // check that actual PersistentVolumeSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (LocalVolumeSourceAssert) assertThat(actual.getLocal()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "local"));
  }


  /**
   * Navigates to the property mountOptions so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> mountOptions()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getMountOptions(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "mountOptions"));
    return answer;
  }


  /**
   * Navigates to the property nfs so that assertions can be done on it
   */
  public NFSVolumeSourceAssert nfs()  {
    // check that actual PersistentVolumeSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (NFSVolumeSourceAssert) assertThat(actual.getNfs()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "nfs"));
  }


  /**
   * Navigates to the property nodeAffinity so that assertions can be done on it
   */
  public VolumeNodeAffinityAssert nodeAffinity()  {
    // check that actual PersistentVolumeSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (VolumeNodeAffinityAssert) assertThat(actual.getNodeAffinity()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "nodeAffinity"));
  }


  /**
   * Navigates to the property persistentVolumeReclaimPolicy so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert persistentVolumeReclaimPolicy()  {
    // check that actual PersistentVolumeSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getPersistentVolumeReclaimPolicy()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "persistentVolumeReclaimPolicy"));
  }


  /**
   * Navigates to the property photonPersistentDisk so that assertions can be done on it
   */
  public PhotonPersistentDiskVolumeSourceAssert photonPersistentDisk()  {
    // check that actual PersistentVolumeSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (PhotonPersistentDiskVolumeSourceAssert) assertThat(actual.getPhotonPersistentDisk()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "photonPersistentDisk"));
  }


  /**
   * Navigates to the property portworxVolume so that assertions can be done on it
   */
  public PortworxVolumeSourceAssert portworxVolume()  {
    // check that actual PersistentVolumeSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (PortworxVolumeSourceAssert) assertThat(actual.getPortworxVolume()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "portworxVolume"));
  }


  /**
   * Navigates to the property quobyte so that assertions can be done on it
   */
  public QuobyteVolumeSourceAssert quobyte()  {
    // check that actual PersistentVolumeSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (QuobyteVolumeSourceAssert) assertThat(actual.getQuobyte()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "quobyte"));
  }


  /**
   * Navigates to the property rbd so that assertions can be done on it
   */
  public RBDPersistentVolumeSourceAssert rbd()  {
    // check that actual PersistentVolumeSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (RBDPersistentVolumeSourceAssert) assertThat(actual.getRbd()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "rbd"));
  }


  /**
   * Navigates to the property scaleIO so that assertions can be done on it
   */
  public ScaleIOPersistentVolumeSourceAssert scaleIO()  {
    // check that actual PersistentVolumeSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ScaleIOPersistentVolumeSourceAssert) assertThat(actual.getScaleIO()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "scaleIO"));
  }


  /**
   * Navigates to the property storageClassName so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert storageClassName()  {
    // check that actual PersistentVolumeSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getStorageClassName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "storageClassName"));
  }


  /**
   * Navigates to the property storageos so that assertions can be done on it
   */
  public StorageOSPersistentVolumeSourceAssert storageos()  {
    // check that actual PersistentVolumeSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (StorageOSPersistentVolumeSourceAssert) assertThat(actual.getStorageos()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "storageos"));
  }


  /**
   * Navigates to the property volumeMode so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert volumeMode()  {
    // check that actual PersistentVolumeSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getVolumeMode()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "volumeMode"));
  }


  /**
   * Navigates to the property vsphereVolume so that assertions can be done on it
   */
  public VsphereVirtualDiskVolumeSourceAssert vsphereVolume()  {
    // check that actual PersistentVolumeSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (VsphereVirtualDiskVolumeSourceAssert) assertThat(actual.getVsphereVolume()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "vsphereVolume"));
  }


}
