package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link PersistentVolumeClaimStatus} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractPersistentVolumeClaimStatusAssert<S extends AbstractPersistentVolumeClaimStatusAssert<S, A>, A extends PersistentVolumeClaimStatus> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractPersistentVolumeClaimStatusAssert}</code> to make assertions on actual PersistentVolumeClaimStatus.
   * @param actual the PersistentVolumeClaimStatus we want to make assertions on.
   */
  protected AbstractPersistentVolumeClaimStatusAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property accessModes so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> accessModes()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getAccessModes(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "accessModes"));
    return answer;
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual PersistentVolumeClaimStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property capacity so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert capacity()  {
    // check that actual PersistentVolumeClaimStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getCapacity()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "capacity"));
  }


  /**
   * Navigates to the property conditions so that assertions can be done on it
   */
  public NavigationListAssert<PersistentVolumeClaimCondition, PersistentVolumeClaimConditionAssert> conditions()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<PersistentVolumeClaimCondition, PersistentVolumeClaimConditionAssert> assertFactory = new AssertFactory<PersistentVolumeClaimCondition, PersistentVolumeClaimConditionAssert>() {
      public PersistentVolumeClaimConditionAssert createAssert(PersistentVolumeClaimCondition t) {
        return (PersistentVolumeClaimConditionAssert) assertThat(t);
      }
    };
    NavigationListAssert<PersistentVolumeClaimCondition, PersistentVolumeClaimConditionAssert> answer = new NavigationListAssert<PersistentVolumeClaimCondition, PersistentVolumeClaimConditionAssert>(actual.getConditions(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "conditions"));
    return answer;
  }


  /**
   * Navigates to the property phase so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert phase()  {
    // check that actual PersistentVolumeClaimStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getPhase()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "phase"));
  }


}
