package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link PatchOptions} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractPatchOptionsAssert<S extends AbstractPatchOptionsAssert<S, A>, A extends PatchOptions> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractPatchOptionsAssert}</code> to make assertions on actual PatchOptions.
   * @param actual the PatchOptions we want to make assertions on.
   */
  protected AbstractPatchOptionsAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual PatchOptions we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property apiVersion so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert apiVersion()  {
    // check that actual PatchOptions we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getApiVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "apiVersion"));
  }


  /**
   * Navigates to the property dryRun so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> dryRun()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getDryRun(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "dryRun"));
    return answer;
  }


  /**
   * Navigates to the property fieldManager so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert fieldManager()  {
    // check that actual PatchOptions we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getFieldManager()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "fieldManager"));
  }


  /**
   * Navigates to the property force so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert force()  {
    // check that actual PatchOptions we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getForce()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "force"));
  }


  /**
   * Navigates to the property kind so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert kind()  {
    // check that actual PatchOptions we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getKind()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "kind"));
  }


}
