package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link OwnerReference} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractOwnerReferenceAssert<S extends AbstractOwnerReferenceAssert<S, A>, A extends OwnerReference> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractOwnerReferenceAssert}</code> to make assertions on actual OwnerReference.
   * @param actual the OwnerReference we want to make assertions on.
   */
  protected AbstractOwnerReferenceAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual OwnerReference we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property apiVersion so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert apiVersion()  {
    // check that actual OwnerReference we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getApiVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "apiVersion"));
  }


  /**
   * Navigates to the property blockOwnerDeletion so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert blockOwnerDeletion()  {
    // check that actual OwnerReference we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getBlockOwnerDeletion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "blockOwnerDeletion"));
  }


  /**
   * Navigates to the property controller so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert controller()  {
    // check that actual OwnerReference we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getController()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "controller"));
  }


  /**
   * Navigates to the property kind so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert kind()  {
    // check that actual OwnerReference we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getKind()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "kind"));
  }


  /**
   * Navigates to the property name so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert name()  {
    // check that actual OwnerReference we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "name"));
  }


  /**
   * Navigates to the property uid so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert uid()  {
    // check that actual OwnerReference we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getUid()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "uid"));
  }


}
