package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link ObjectMetricSource} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractObjectMetricSourceAssert<S extends AbstractObjectMetricSourceAssert<S, A>, A extends ObjectMetricSource> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractObjectMetricSourceAssert}</code> to make assertions on actual ObjectMetricSource.
   * @param actual the ObjectMetricSource we want to make assertions on.
   */
  protected AbstractObjectMetricSourceAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual ObjectMetricSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property describedObject so that assertions can be done on it
   */
  public CrossVersionObjectReferenceAssert describedObject()  {
    // check that actual ObjectMetricSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (CrossVersionObjectReferenceAssert) assertThat(actual.getDescribedObject()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "describedObject"));
  }


  /**
   * Navigates to the property metric so that assertions can be done on it
   */
  public MetricIdentifierAssert metric()  {
    // check that actual ObjectMetricSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (MetricIdentifierAssert) assertThat(actual.getMetric()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "metric"));
  }


  /**
   * Navigates to the property target so that assertions can be done on it
   */
  public MetricTargetAssert target()  {
    // check that actual ObjectMetricSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (MetricTargetAssert) assertThat(actual.getTarget()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "target"));
  }


}
