package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link NodeStatus} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractNodeStatusAssert<S extends AbstractNodeStatusAssert<S, A>, A extends NodeStatus> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractNodeStatusAssert}</code> to make assertions on actual NodeStatus.
   * @param actual the NodeStatus we want to make assertions on.
   */
  protected AbstractNodeStatusAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual NodeStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property addresses so that assertions can be done on it
   */
  public NavigationListAssert<NodeAddress, NodeAddressAssert> addresses()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<NodeAddress, NodeAddressAssert> assertFactory = new AssertFactory<NodeAddress, NodeAddressAssert>() {
      public NodeAddressAssert createAssert(NodeAddress t) {
        return (NodeAddressAssert) assertThat(t);
      }
    };
    NavigationListAssert<NodeAddress, NodeAddressAssert> answer = new NavigationListAssert<NodeAddress, NodeAddressAssert>(actual.getAddresses(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "addresses"));
    return answer;
  }


  /**
   * Navigates to the property allocatable so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert allocatable()  {
    // check that actual NodeStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAllocatable()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "allocatable"));
  }


  /**
   * Navigates to the property capacity so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert capacity()  {
    // check that actual NodeStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getCapacity()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "capacity"));
  }


  /**
   * Navigates to the property conditions so that assertions can be done on it
   */
  public NavigationListAssert<NodeCondition, NodeConditionAssert> conditions()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<NodeCondition, NodeConditionAssert> assertFactory = new AssertFactory<NodeCondition, NodeConditionAssert>() {
      public NodeConditionAssert createAssert(NodeCondition t) {
        return (NodeConditionAssert) assertThat(t);
      }
    };
    NavigationListAssert<NodeCondition, NodeConditionAssert> answer = new NavigationListAssert<NodeCondition, NodeConditionAssert>(actual.getConditions(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "conditions"));
    return answer;
  }


  /**
   * Navigates to the property config so that assertions can be done on it
   */
  public NodeConfigStatusAssert config()  {
    // check that actual NodeStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (NodeConfigStatusAssert) assertThat(actual.getConfig()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "config"));
  }


  /**
   * Navigates to the property daemonEndpoints so that assertions can be done on it
   */
  public NodeDaemonEndpointsAssert daemonEndpoints()  {
    // check that actual NodeStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (NodeDaemonEndpointsAssert) assertThat(actual.getDaemonEndpoints()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "daemonEndpoints"));
  }


  /**
   * Navigates to the property images so that assertions can be done on it
   */
  public NavigationListAssert<ContainerImage, ContainerImageAssert> images()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<ContainerImage, ContainerImageAssert> assertFactory = new AssertFactory<ContainerImage, ContainerImageAssert>() {
      public ContainerImageAssert createAssert(ContainerImage t) {
        return (ContainerImageAssert) assertThat(t);
      }
    };
    NavigationListAssert<ContainerImage, ContainerImageAssert> answer = new NavigationListAssert<ContainerImage, ContainerImageAssert>(actual.getImages(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "images"));
    return answer;
  }


  /**
   * Navigates to the property nodeInfo so that assertions can be done on it
   */
  public NodeSystemInfoAssert nodeInfo()  {
    // check that actual NodeStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (NodeSystemInfoAssert) assertThat(actual.getNodeInfo()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "nodeInfo"));
  }


  /**
   * Navigates to the property phase so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert phase()  {
    // check that actual NodeStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getPhase()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "phase"));
  }


  /**
   * Navigates to the property volumesAttached so that assertions can be done on it
   */
  public NavigationListAssert<AttachedVolume, AttachedVolumeAssert> volumesAttached()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<AttachedVolume, AttachedVolumeAssert> assertFactory = new AssertFactory<AttachedVolume, AttachedVolumeAssert>() {
      public AttachedVolumeAssert createAssert(AttachedVolume t) {
        return (AttachedVolumeAssert) assertThat(t);
      }
    };
    NavigationListAssert<AttachedVolume, AttachedVolumeAssert> answer = new NavigationListAssert<AttachedVolume, AttachedVolumeAssert>(actual.getVolumesAttached(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "volumesAttached"));
    return answer;
  }


  /**
   * Navigates to the property volumesInUse so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> volumesInUse()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getVolumesInUse(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "volumesInUse"));
    return answer;
  }


}
