package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link NodeSpec} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractNodeSpecAssert<S extends AbstractNodeSpecAssert<S, A>, A extends NodeSpec> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractNodeSpecAssert}</code> to make assertions on actual NodeSpec.
   * @param actual the NodeSpec we want to make assertions on.
   */
  protected AbstractNodeSpecAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual NodeSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property configSource so that assertions can be done on it
   */
  public NodeConfigSourceAssert configSource()  {
    // check that actual NodeSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (NodeConfigSourceAssert) assertThat(actual.getConfigSource()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "configSource"));
  }


  /**
   * Navigates to the property externalID so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert externalID()  {
    // check that actual NodeSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getExternalID()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "externalID"));
  }


  /**
   * Navigates to the property podCIDR so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert podCIDR()  {
    // check that actual NodeSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getPodCIDR()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "podCIDR"));
  }


  /**
   * Navigates to the property podCIDRs so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> podCIDRs()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getPodCIDRs(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "podCIDRs"));
    return answer;
  }


  /**
   * Navigates to the property providerID so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert providerID()  {
    // check that actual NodeSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getProviderID()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "providerID"));
  }


  /**
   * Navigates to the property taints so that assertions can be done on it
   */
  public NavigationListAssert<Taint, TaintAssert> taints()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<Taint, TaintAssert> assertFactory = new AssertFactory<Taint, TaintAssert>() {
      public TaintAssert createAssert(Taint t) {
        return (TaintAssert) assertThat(t);
      }
    };
    NavigationListAssert<Taint, TaintAssert> answer = new NavigationListAssert<Taint, TaintAssert>(actual.getTaints(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "taints"));
    return answer;
  }


  /**
   * Navigates to the property unschedulable so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert unschedulable()  {
    // check that actual NodeSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getUnschedulable()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "unschedulable"));
  }


}
