package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link NodeSelector} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractNodeSelectorAssert<S extends AbstractNodeSelectorAssert<S, A>, A extends NodeSelector> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractNodeSelectorAssert}</code> to make assertions on actual NodeSelector.
   * @param actual the NodeSelector we want to make assertions on.
   */
  protected AbstractNodeSelectorAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual NodeSelector we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property nodeSelectorTerms so that assertions can be done on it
   */
  public NavigationListAssert<NodeSelectorTerm, NodeSelectorTermAssert> nodeSelectorTerms()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<NodeSelectorTerm, NodeSelectorTermAssert> assertFactory = new AssertFactory<NodeSelectorTerm, NodeSelectorTermAssert>() {
      public NodeSelectorTermAssert createAssert(NodeSelectorTerm t) {
        return (NodeSelectorTermAssert) assertThat(t);
      }
    };
    NavigationListAssert<NodeSelectorTerm, NodeSelectorTermAssert> answer = new NavigationListAssert<NodeSelectorTerm, NodeSelectorTermAssert>(actual.getNodeSelectorTerms(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "nodeSelectorTerms"));
    return answer;
  }


}
