package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link NodeList} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractNodeListAssert<S extends AbstractNodeListAssert<S, A>, A extends NodeList> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractNodeListAssert}</code> to make assertions on actual NodeList.
   * @param actual the NodeList we want to make assertions on.
   */
  protected AbstractNodeListAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual NodeList we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property apiVersion so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert apiVersion()  {
    // check that actual NodeList we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getApiVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "apiVersion"));
  }


  /**
   * Navigates to the property items so that assertions can be done on it
   */
  public NavigationListAssert<Node, NodeAssert> items()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<Node, NodeAssert> assertFactory = new AssertFactory<Node, NodeAssert>() {
      public NodeAssert createAssert(Node t) {
        return (NodeAssert) assertThat(t);
      }
    };
    NavigationListAssert<Node, NodeAssert> answer = new NavigationListAssert<Node, NodeAssert>(actual.getItems(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "items"));
    return answer;
  }


  /**
   * Navigates to the property kind so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert kind()  {
    // check that actual NodeList we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getKind()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "kind"));
  }


  /**
   * Navigates to the property metadata so that assertions can be done on it
   */
  public ListMetaAssert metadata()  {
    // check that actual NodeList we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ListMetaAssert) assertThat(actual.getMetadata()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "metadata"));
  }


}
