package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link NodeConfigStatus} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractNodeConfigStatusAssert<S extends AbstractNodeConfigStatusAssert<S, A>, A extends NodeConfigStatus> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractNodeConfigStatusAssert}</code> to make assertions on actual NodeConfigStatus.
   * @param actual the NodeConfigStatus we want to make assertions on.
   */
  protected AbstractNodeConfigStatusAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property active so that assertions can be done on it
   */
  public NodeConfigSourceAssert active()  {
    // check that actual NodeConfigStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (NodeConfigSourceAssert) assertThat(actual.getActive()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "active"));
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual NodeConfigStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property assigned so that assertions can be done on it
   */
  public NodeConfigSourceAssert assigned()  {
    // check that actual NodeConfigStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (NodeConfigSourceAssert) assertThat(actual.getAssigned()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "assigned"));
  }


  /**
   * Navigates to the property error so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert error()  {
    // check that actual NodeConfigStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getError()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "error"));
  }


  /**
   * Navigates to the property lastKnownGood so that assertions can be done on it
   */
  public NodeConfigSourceAssert lastKnownGood()  {
    // check that actual NodeConfigStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (NodeConfigSourceAssert) assertThat(actual.getLastKnownGood()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "lastKnownGood"));
  }


}
