package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link NodeConfigSource} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractNodeConfigSourceAssert<S extends AbstractNodeConfigSourceAssert<S, A>, A extends NodeConfigSource> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractNodeConfigSourceAssert}</code> to make assertions on actual NodeConfigSource.
   * @param actual the NodeConfigSource we want to make assertions on.
   */
  protected AbstractNodeConfigSourceAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual NodeConfigSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property configMap so that assertions can be done on it
   */
  public ConfigMapNodeConfigSourceAssert configMap()  {
    // check that actual NodeConfigSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ConfigMapNodeConfigSourceAssert) assertThat(actual.getConfigMap()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "configMap"));
  }


}
