package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link NodeAffinity} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractNodeAffinityAssert<S extends AbstractNodeAffinityAssert<S, A>, A extends NodeAffinity> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractNodeAffinityAssert}</code> to make assertions on actual NodeAffinity.
   * @param actual the NodeAffinity we want to make assertions on.
   */
  protected AbstractNodeAffinityAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual NodeAffinity we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property preferredDuringSchedulingIgnoredDuringExecution so that assertions can be done on it
   */
  public NavigationListAssert<PreferredSchedulingTerm, PreferredSchedulingTermAssert> preferredDuringSchedulingIgnoredDuringExecution()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<PreferredSchedulingTerm, PreferredSchedulingTermAssert> assertFactory = new AssertFactory<PreferredSchedulingTerm, PreferredSchedulingTermAssert>() {
      public PreferredSchedulingTermAssert createAssert(PreferredSchedulingTerm t) {
        return (PreferredSchedulingTermAssert) assertThat(t);
      }
    };
    NavigationListAssert<PreferredSchedulingTerm, PreferredSchedulingTermAssert> answer = new NavigationListAssert<PreferredSchedulingTerm, PreferredSchedulingTermAssert>(actual.getPreferredDuringSchedulingIgnoredDuringExecution(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "preferredDuringSchedulingIgnoredDuringExecution"));
    return answer;
  }


  /**
   * Navigates to the property requiredDuringSchedulingIgnoredDuringExecution so that assertions can be done on it
   */
  public NodeSelectorAssert requiredDuringSchedulingIgnoredDuringExecution()  {
    // check that actual NodeAffinity we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (NodeSelectorAssert) assertThat(actual.getRequiredDuringSchedulingIgnoredDuringExecution()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "requiredDuringSchedulingIgnoredDuringExecution"));
  }


}
