package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link NodeAddress} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractNodeAddressAssert<S extends AbstractNodeAddressAssert<S, A>, A extends NodeAddress> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractNodeAddressAssert}</code> to make assertions on actual NodeAddress.
   * @param actual the NodeAddress we want to make assertions on.
   */
  protected AbstractNodeAddressAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual NodeAddress we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property address so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert address()  {
    // check that actual NodeAddress we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getAddress()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "address"));
  }


  /**
   * Navigates to the property type so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert type()  {
    // check that actual NodeAddress we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getType()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "type"));
  }


}
