package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link MicroTime} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractMicroTimeAssert<S extends AbstractMicroTimeAssert<S, A>, A extends MicroTime> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractMicroTimeAssert}</code> to make assertions on actual MicroTime.
   * @param actual the MicroTime we want to make assertions on.
   */
  protected AbstractMicroTimeAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual MicroTime we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property time so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert time()  {
    // check that actual MicroTime we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getTime()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "time"));
  }


}
