package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link MetricTarget} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractMetricTargetAssert<S extends AbstractMetricTargetAssert<S, A>, A extends MetricTarget> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractMetricTargetAssert}</code> to make assertions on actual MetricTarget.
   * @param actual the MetricTarget we want to make assertions on.
   */
  protected AbstractMetricTargetAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual MetricTarget we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Verifies that the actual MetricTarget's averageUtilization is equal to the given one.
   * @param averageUtilization the given averageUtilization to compare the actual MetricTarget's averageUtilization to.
   * @return this assertion object.
   * @throws AssertionError - if the actual MetricTarget's averageUtilization is not equal to the given one.
   */
  public S hasAverageUtilization(Integer averageUtilization) {
    // check that actual MetricTarget we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting averageUtilization of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualAverageUtilization = actual.getAverageUtilization();
    if (!Objects.areEqual(actualAverageUtilization, averageUtilization)) {
      failWithMessage(assertjErrorMessage, actual, averageUtilization, actualAverageUtilization);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property averageValue so that assertions can be done on it
   */
  public QuantityAssert averageValue()  {
    // check that actual MetricTarget we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (QuantityAssert) assertThat(actual.getAverageValue()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "averageValue"));
  }


  /**
   * Navigates to the property type so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert type()  {
    // check that actual MetricTarget we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getType()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "type"));
  }


  /**
   * Navigates to the property value so that assertions can be done on it
   */
  public QuantityAssert value()  {
    // check that actual MetricTarget we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (QuantityAssert) assertThat(actual.getValue()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "value"));
  }


}
