package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link MetricSpec} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractMetricSpecAssert<S extends AbstractMetricSpecAssert<S, A>, A extends MetricSpec> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractMetricSpecAssert}</code> to make assertions on actual MetricSpec.
   * @param actual the MetricSpec we want to make assertions on.
   */
  protected AbstractMetricSpecAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual MetricSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property external so that assertions can be done on it
   */
  public ExternalMetricSourceAssert external()  {
    // check that actual MetricSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ExternalMetricSourceAssert) assertThat(actual.getExternal()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "external"));
  }


  /**
   * Navigates to the property object so that assertions can be done on it
   */
  public ObjectMetricSourceAssert object()  {
    // check that actual MetricSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ObjectMetricSourceAssert) assertThat(actual.getObject()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "object"));
  }


  /**
   * Navigates to the property pods so that assertions can be done on it
   */
  public PodsMetricSourceAssert pods()  {
    // check that actual MetricSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (PodsMetricSourceAssert) assertThat(actual.getPods()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "pods"));
  }


  /**
   * Navigates to the property resource so that assertions can be done on it
   */
  public ResourceMetricSourceAssert resource()  {
    // check that actual MetricSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ResourceMetricSourceAssert) assertThat(actual.getResource()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "resource"));
  }


  /**
   * Navigates to the property type so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert type()  {
    // check that actual MetricSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getType()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "type"));
  }


}
