package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link ManagedFieldsEntry} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractManagedFieldsEntryAssert<S extends AbstractManagedFieldsEntryAssert<S, A>, A extends ManagedFieldsEntry> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractManagedFieldsEntryAssert}</code> to make assertions on actual ManagedFieldsEntry.
   * @param actual the ManagedFieldsEntry we want to make assertions on.
   */
  protected AbstractManagedFieldsEntryAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual ManagedFieldsEntry we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property apiVersion so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert apiVersion()  {
    // check that actual ManagedFieldsEntry we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getApiVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "apiVersion"));
  }


  /**
   * Navigates to the property fieldsType so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert fieldsType()  {
    // check that actual ManagedFieldsEntry we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getFieldsType()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "fieldsType"));
  }


  /**
   * Navigates to the property fieldsV1 so that assertions can be done on it
   */
  public FieldsV1Assert fieldsV1()  {
    // check that actual ManagedFieldsEntry we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (FieldsV1Assert) assertThat(actual.getFieldsV1()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "fieldsV1"));
  }


  /**
   * Navigates to the property manager so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert manager()  {
    // check that actual ManagedFieldsEntry we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getManager()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "manager"));
  }


  /**
   * Navigates to the property operation so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert operation()  {
    // check that actual ManagedFieldsEntry we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getOperation()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "operation"));
  }


  /**
   * Navigates to the property time so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert time()  {
    // check that actual ManagedFieldsEntry we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getTime()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "time"));
  }


}
