package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link LoadBalancerIngress} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractLoadBalancerIngressAssert<S extends AbstractLoadBalancerIngressAssert<S, A>, A extends LoadBalancerIngress> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractLoadBalancerIngressAssert}</code> to make assertions on actual LoadBalancerIngress.
   * @param actual the LoadBalancerIngress we want to make assertions on.
   */
  protected AbstractLoadBalancerIngressAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual LoadBalancerIngress we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property hostname so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert hostname()  {
    // check that actual LoadBalancerIngress we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getHostname()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "hostname"));
  }


  /**
   * Navigates to the property ip so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert ip()  {
    // check that actual LoadBalancerIngress we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getIp()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "ip"));
  }


}
