package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link ListOptions} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractListOptionsAssert<S extends AbstractListOptionsAssert<S, A>, A extends ListOptions> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractListOptionsAssert}</code> to make assertions on actual ListOptions.
   * @param actual the ListOptions we want to make assertions on.
   */
  protected AbstractListOptionsAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual ListOptions we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property allowWatchBookmarks so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert allowWatchBookmarks()  {
    // check that actual ListOptions we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getAllowWatchBookmarks()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "allowWatchBookmarks"));
  }


  /**
   * Navigates to the property apiVersion so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert apiVersion()  {
    // check that actual ListOptions we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getApiVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "apiVersion"));
  }


  /**
   * Navigates to the property continue so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert expectedContinue()  {
    // check that actual ListOptions we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getContinue()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "continue"));
  }


  /**
   * Navigates to the property fieldSelector so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert fieldSelector()  {
    // check that actual ListOptions we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getFieldSelector()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "fieldSelector"));
  }


  /**
   * Navigates to the property kind so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert kind()  {
    // check that actual ListOptions we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getKind()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "kind"));
  }


  /**
   * Navigates to the property labelSelector so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert labelSelector()  {
    // check that actual ListOptions we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getLabelSelector()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "labelSelector"));
  }


  /**
   * Verifies that the actual ListOptions's limit is equal to the given one.
   * @param limit the given limit to compare the actual ListOptions's limit to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ListOptions's limit is not equal to the given one.
   */
  public S hasLimit(Long limit) {
    // check that actual ListOptions we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting limit of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualLimit = actual.getLimit();
    if (!Objects.areEqual(actualLimit, limit)) {
      failWithMessage(assertjErrorMessage, actual, limit, actualLimit);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property resourceVersion so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert resourceVersion()  {
    // check that actual ListOptions we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getResourceVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "resourceVersion"));
  }


  /**
   * Verifies that the actual ListOptions's timeoutSeconds is equal to the given one.
   * @param timeoutSeconds the given timeoutSeconds to compare the actual ListOptions's timeoutSeconds to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ListOptions's timeoutSeconds is not equal to the given one.
   */
  public S hasTimeoutSeconds(Long timeoutSeconds) {
    // check that actual ListOptions we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting timeoutSeconds of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualTimeoutSeconds = actual.getTimeoutSeconds();
    if (!Objects.areEqual(actualTimeoutSeconds, timeoutSeconds)) {
      failWithMessage(assertjErrorMessage, actual, timeoutSeconds, actualTimeoutSeconds);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property watch so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert watch()  {
    // check that actual ListOptions we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getWatch()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "watch"));
  }


}
