package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link ListMeta} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractListMetaAssert<S extends AbstractListMetaAssert<S, A>, A extends ListMeta> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractListMetaAssert}</code> to make assertions on actual ListMeta.
   * @param actual the ListMeta we want to make assertions on.
   */
  protected AbstractListMetaAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual ListMeta we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property continue so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert expectedContinue()  {
    // check that actual ListMeta we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getContinue()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "continue"));
  }


  /**
   * Verifies that the actual ListMeta's remainingItemCount is equal to the given one.
   * @param remainingItemCount the given remainingItemCount to compare the actual ListMeta's remainingItemCount to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ListMeta's remainingItemCount is not equal to the given one.
   */
  public S hasRemainingItemCount(Long remainingItemCount) {
    // check that actual ListMeta we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting remainingItemCount of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualRemainingItemCount = actual.getRemainingItemCount();
    if (!Objects.areEqual(actualRemainingItemCount, remainingItemCount)) {
      failWithMessage(assertjErrorMessage, actual, remainingItemCount, actualRemainingItemCount);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property resourceVersion so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert resourceVersion()  {
    // check that actual ListMeta we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getResourceVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "resourceVersion"));
  }


  /**
   * Navigates to the property selfLink so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert selfLink()  {
    // check that actual ListMeta we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getSelfLink()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "selfLink"));
  }


}
