package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link LimitRangeSpec} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractLimitRangeSpecAssert<S extends AbstractLimitRangeSpecAssert<S, A>, A extends LimitRangeSpec> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractLimitRangeSpecAssert}</code> to make assertions on actual LimitRangeSpec.
   * @param actual the LimitRangeSpec we want to make assertions on.
   */
  protected AbstractLimitRangeSpecAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual LimitRangeSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property limits so that assertions can be done on it
   */
  public NavigationListAssert<LimitRangeItem, LimitRangeItemAssert> limits()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<LimitRangeItem, LimitRangeItemAssert> assertFactory = new AssertFactory<LimitRangeItem, LimitRangeItemAssert>() {
      public LimitRangeItemAssert createAssert(LimitRangeItem t) {
        return (LimitRangeItemAssert) assertThat(t);
      }
    };
    NavigationListAssert<LimitRangeItem, LimitRangeItemAssert> answer = new NavigationListAssert<LimitRangeItem, LimitRangeItemAssert>(actual.getLimits(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "limits"));
    return answer;
  }


}
