package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link KubernetesResourceList} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractKubernetesResourceListAssert<S extends AbstractKubernetesResourceListAssert<S, A>, A extends KubernetesResourceList> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractKubernetesResourceListAssert}</code> to make assertions on actual KubernetesResourceList.
   * @param actual the KubernetesResourceList we want to make assertions on.
   */
  protected AbstractKubernetesResourceListAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property items so that assertions can be done on it
   */
  public NavigationListAssert<HasMetadata, HasMetadataAssert> items()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<HasMetadata, HasMetadataAssert> assertFactory = new AssertFactory<HasMetadata, HasMetadataAssert>() {
      public HasMetadataAssert createAssert(HasMetadata t) {
        return (HasMetadataAssert) assertThat(t);
      }
    };
    NavigationListAssert<HasMetadata, HasMetadataAssert> answer = new NavigationListAssert<HasMetadata, HasMetadataAssert>(actual.getItems(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "items"));
    return answer;
  }


  /**
   * Navigates to the property metadata so that assertions can be done on it
   */
  public ListMetaAssert metadata()  {
    // check that actual KubernetesResourceList we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ListMetaAssert) assertThat(actual.getMetadata()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "metadata"));
  }


}
