package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link KubeSchema} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractKubeSchemaAssert<S extends AbstractKubeSchemaAssert<S, A>, A extends KubeSchema> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractKubeSchemaAssert}</code> to make assertions on actual KubeSchema.
   * @param actual the KubeSchema we want to make assertions on.
   */
  protected AbstractKubeSchemaAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property aPIGroup so that assertions can be done on it
   */
  public APIGroupAssert aPIGroup()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (APIGroupAssert) assertThat(actual.getAPIGroup()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "aPIGroup"));
  }


  /**
   * Navigates to the property aPIGroupList so that assertions can be done on it
   */
  public APIGroupListAssert aPIGroupList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (APIGroupListAssert) assertThat(actual.getAPIGroupList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "aPIGroupList"));
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property admissionRequest so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.admission.AdmissionRequestAssert admissionRequest()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.admission.AdmissionRequestAssert) assertThat(actual.getAdmissionRequest()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "admissionRequest"));
  }


  /**
   * Navigates to the property admissionResponse so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.admission.AdmissionResponseAssert admissionResponse()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.admission.AdmissionResponseAssert) assertThat(actual.getAdmissionResponse()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "admissionResponse"));
  }


  /**
   * Navigates to the property admissionReview so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.admission.AdmissionReviewAssert admissionReview()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.admission.AdmissionReviewAssert) assertThat(actual.getAdmissionReview()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "admissionReview"));
  }


  /**
   * Navigates to the property aggregationRule so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.rbac.AggregationRuleAssert aggregationRule()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.rbac.AggregationRuleAssert) assertThat(actual.getAggregationRule()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "aggregationRule"));
  }


  /**
   * Navigates to the property baseKubernetesList so that assertions can be done on it
   */
  public BaseKubernetesListAssert baseKubernetesList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (BaseKubernetesListAssert) assertThat(actual.getBaseKubernetesList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "baseKubernetesList"));
  }


  /**
   * Navigates to the property binding so that assertions can be done on it
   */
  public BindingAssert binding()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (BindingAssert) assertThat(actual.getBinding()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "binding"));
  }


  /**
   * Navigates to the property buildConfigList so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.BuildConfigListAssert buildConfigList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.BuildConfigListAssert) assertThat(actual.getBuildConfigList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "buildConfigList"));
  }


  /**
   * Navigates to the property buildList so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.BuildListAssert buildList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.BuildListAssert) assertThat(actual.getBuildList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "buildList"));
  }


  /**
   * Navigates to the property buildRequest so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.BuildRequestAssert buildRequest()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.BuildRequestAssert) assertThat(actual.getBuildRequest()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "buildRequest"));
  }


  /**
   * Navigates to the property cSIDriver so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.storage.v1beta1.CSIDriverAssert cSIDriver()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.storage.v1beta1.CSIDriverAssert) assertThat(actual.getCSIDriver()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "cSIDriver"));
  }


  /**
   * Navigates to the property cSIDriverList so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.storage.v1beta1.CSIDriverListAssert cSIDriverList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.storage.v1beta1.CSIDriverListAssert) assertThat(actual.getCSIDriverList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "cSIDriverList"));
  }


  /**
   * Navigates to the property cSINode so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.storage.v1beta1.CSINodeAssert cSINode()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.storage.v1beta1.CSINodeAssert) assertThat(actual.getCSINode()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "cSINode"));
  }


  /**
   * Navigates to the property cSINodeList so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.storage.v1beta1.CSINodeListAssert cSINodeList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.storage.v1beta1.CSINodeListAssert) assertThat(actual.getCSINodeList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "cSINodeList"));
  }


  /**
   * Navigates to the property certificateSigningRequest so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.certificates.CertificateSigningRequestAssert certificateSigningRequest()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.certificates.CertificateSigningRequestAssert) assertThat(actual.getCertificateSigningRequest()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "certificateSigningRequest"));
  }


  /**
   * Navigates to the property certificateSigningRequestCondition so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.certificates.CertificateSigningRequestConditionAssert certificateSigningRequestCondition()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.certificates.CertificateSigningRequestConditionAssert) assertThat(actual.getCertificateSigningRequestCondition()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "certificateSigningRequestCondition"));
  }


  /**
   * Navigates to the property certificateSigningRequestList so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.certificates.CertificateSigningRequestListAssert certificateSigningRequestList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.certificates.CertificateSigningRequestListAssert) assertThat(actual.getCertificateSigningRequestList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "certificateSigningRequestList"));
  }


  /**
   * Navigates to the property certificateSigningRequestSpec so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.certificates.CertificateSigningRequestSpecAssert certificateSigningRequestSpec()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.certificates.CertificateSigningRequestSpecAssert) assertThat(actual.getCertificateSigningRequestSpec()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "certificateSigningRequestSpec"));
  }


  /**
   * Navigates to the property certificateSigningRequestStatus so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.certificates.CertificateSigningRequestStatusAssert certificateSigningRequestStatus()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.certificates.CertificateSigningRequestStatusAssert) assertThat(actual.getCertificateSigningRequestStatus()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "certificateSigningRequestStatus"));
  }


  /**
   * Navigates to the property clusterRole so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.rbac.ClusterRoleAssert clusterRole()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.rbac.ClusterRoleAssert) assertThat(actual.getClusterRole()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "clusterRole"));
  }


  /**
   * Navigates to the property clusterRoleBinding so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingAssert clusterRoleBinding()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingAssert) assertThat(actual.getClusterRoleBinding()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "clusterRoleBinding"));
  }


  /**
   * Navigates to the property clusterRoleBindingList so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingListAssert clusterRoleBindingList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingListAssert) assertThat(actual.getClusterRoleBindingList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "clusterRoleBindingList"));
  }


  /**
   * Navigates to the property clusterRoleList so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.rbac.ClusterRoleListAssert clusterRoleList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.rbac.ClusterRoleListAssert) assertThat(actual.getClusterRoleList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "clusterRoleList"));
  }


  /**
   * Navigates to the property componentStatusList so that assertions can be done on it
   */
  public ComponentStatusListAssert componentStatusList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ComponentStatusListAssert) assertThat(actual.getComponentStatusList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "componentStatusList"));
  }


  /**
   * Navigates to the property config so that assertions can be done on it
   */
  public ConfigAssert config()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ConfigAssert) assertThat(actual.getConfig()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "config"));
  }


  /**
   * Navigates to the property configMap so that assertions can be done on it
   */
  public ConfigMapAssert configMap()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ConfigMapAssert) assertThat(actual.getConfigMap()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "configMap"));
  }


  /**
   * Navigates to the property configMapList so that assertions can be done on it
   */
  public ConfigMapListAssert configMapList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ConfigMapListAssert) assertThat(actual.getConfigMapList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "configMapList"));
  }


  /**
   * Navigates to the property containerStatus so that assertions can be done on it
   */
  public ContainerStatusAssert containerStatus()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ContainerStatusAssert) assertThat(actual.getContainerStatus()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "containerStatus"));
  }


  /**
   * Navigates to the property controllerRevision so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.apps.ControllerRevisionAssert controllerRevision()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.apps.ControllerRevisionAssert) assertThat(actual.getControllerRevision()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "controllerRevision"));
  }


  /**
   * Navigates to the property controllerRevisionList so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.apps.ControllerRevisionListAssert controllerRevisionList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.apps.ControllerRevisionListAssert) assertThat(actual.getControllerRevisionList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "controllerRevisionList"));
  }


  /**
   * Navigates to the property createOptions so that assertions can be done on it
   */
  public CreateOptionsAssert createOptions()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (CreateOptionsAssert) assertThat(actual.getCreateOptions()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "createOptions"));
  }


  /**
   * Navigates to the property cronJob so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.batch.CronJobAssert cronJob()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.batch.CronJobAssert) assertThat(actual.getCronJob()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "cronJob"));
  }


  /**
   * Navigates to the property cronJobList so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.batch.CronJobListAssert cronJobList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.batch.CronJobListAssert) assertThat(actual.getCronJobList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "cronJobList"));
  }


  /**
   * Navigates to the property customResourceDefinition so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinitionAssert customResourceDefinition()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinitionAssert) assertThat(actual.getCustomResourceDefinition()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "customResourceDefinition"));
  }


  /**
   * Navigates to the property customResourceDefinitionCondition so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinitionConditionAssert customResourceDefinitionCondition()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinitionConditionAssert) assertThat(actual.getCustomResourceDefinitionCondition()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "customResourceDefinitionCondition"));
  }


  /**
   * Navigates to the property customResourceDefinitionList so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinitionListAssert customResourceDefinitionList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinitionListAssert) assertThat(actual.getCustomResourceDefinitionList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "customResourceDefinitionList"));
  }


  /**
   * Navigates to the property customResourceDefinitionNames so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinitionNamesAssert customResourceDefinitionNames()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinitionNamesAssert) assertThat(actual.getCustomResourceDefinitionNames()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "customResourceDefinitionNames"));
  }


  /**
   * Navigates to the property customResourceDefinitionSpec so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinitionSpecAssert customResourceDefinitionSpec()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinitionSpecAssert) assertThat(actual.getCustomResourceDefinitionSpec()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "customResourceDefinitionSpec"));
  }


  /**
   * Navigates to the property customResourceDefinitionStatus so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinitionStatusAssert customResourceDefinitionStatus()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinitionStatusAssert) assertThat(actual.getCustomResourceDefinitionStatus()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "customResourceDefinitionStatus"));
  }


  /**
   * Navigates to the property daemonSet so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.apps.DaemonSetAssert daemonSet()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.apps.DaemonSetAssert) assertThat(actual.getDaemonSet()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "daemonSet"));
  }


  /**
   * Navigates to the property daemonSetList so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.apps.DaemonSetListAssert daemonSetList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.apps.DaemonSetListAssert) assertThat(actual.getDaemonSetList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "daemonSetList"));
  }


  /**
   * Navigates to the property deleteOptions so that assertions can be done on it
   */
  public DeleteOptionsAssert deleteOptions()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (DeleteOptionsAssert) assertThat(actual.getDeleteOptions()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "deleteOptions"));
  }


  /**
   * Navigates to the property deployment so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.apps.DeploymentAssert deployment()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.apps.DeploymentAssert) assertThat(actual.getDeployment()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "deployment"));
  }


  /**
   * Navigates to the property deploymentConfig so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.DeploymentConfigAssert deploymentConfig()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.DeploymentConfigAssert) assertThat(actual.getDeploymentConfig()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "deploymentConfig"));
  }


  /**
   * Navigates to the property deploymentConfigList so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.DeploymentConfigListAssert deploymentConfigList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.DeploymentConfigListAssert) assertThat(actual.getDeploymentConfigList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "deploymentConfigList"));
  }


  /**
   * Navigates to the property deploymentList so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.apps.DeploymentListAssert deploymentList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.apps.DeploymentListAssert) assertThat(actual.getDeploymentList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "deploymentList"));
  }


  /**
   * Navigates to the property deploymentRollback so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.extensions.DeploymentRollbackAssert deploymentRollback()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.extensions.DeploymentRollbackAssert) assertThat(actual.getDeploymentRollback()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "deploymentRollback"));
  }


  /**
   * Navigates to the property discoveryEndpointPort so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.discovery.DiscoveryEndpointPortAssert discoveryEndpointPort()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.discovery.DiscoveryEndpointPortAssert) assertThat(actual.getDiscoveryEndpointPort()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "discoveryEndpointPort"));
  }


  /**
   * Navigates to the property endpointPort so that assertions can be done on it
   */
  public EndpointPortAssert endpointPort()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (EndpointPortAssert) assertThat(actual.getEndpointPort()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "endpointPort"));
  }


  /**
   * Navigates to the property endpointSlice so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.discovery.EndpointSliceAssert endpointSlice()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.discovery.EndpointSliceAssert) assertThat(actual.getEndpointSlice()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "endpointSlice"));
  }


  /**
   * Navigates to the property endpointSliceList so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.discovery.EndpointSliceListAssert endpointSliceList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.discovery.EndpointSliceListAssert) assertThat(actual.getEndpointSliceList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "endpointSliceList"));
  }


  /**
   * Navigates to the property endpoints so that assertions can be done on it
   */
  public EndpointsAssert endpoints()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (EndpointsAssert) assertThat(actual.getEndpoints()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "endpoints"));
  }


  /**
   * Navigates to the property endpointsList so that assertions can be done on it
   */
  public EndpointsListAssert endpointsList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (EndpointsListAssert) assertThat(actual.getEndpointsList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "endpointsList"));
  }


  /**
   * Navigates to the property envVar so that assertions can be done on it
   */
  public EnvVarAssert envVar()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (EnvVarAssert) assertThat(actual.getEnvVar()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "envVar"));
  }


  /**
   * Navigates to the property event so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.events.EventAssert event()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.events.EventAssert) assertThat(actual.getEvent()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "event"));
  }


  /**
   * Navigates to the property eventList so that assertions can be done on it
   */
  public EventListAssert eventList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (EventListAssert) assertThat(actual.getEventList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "eventList"));
  }


  /**
   * Navigates to the property eventSeries so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.events.EventSeriesAssert eventSeries()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.events.EventSeriesAssert) assertThat(actual.getEventSeries()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "eventSeries"));
  }


  /**
   * Navigates to the property eventSeriesState so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert eventSeriesState()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getEventSeriesState()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "eventSeriesState"));
  }


  /**
   * Navigates to the property getOptions so that assertions can be done on it
   */
  public GetOptionsAssert getOptions()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (GetOptionsAssert) assertThat(actual.getGetOptions()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "getOptions"));
  }


  /**
   * Navigates to the property group so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.GroupAssert group()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.GroupAssert) assertThat(actual.getGroup()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "group"));
  }


  /**
   * Navigates to the property groupList so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.GroupListAssert groupList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.GroupListAssert) assertThat(actual.getGroupList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "groupList"));
  }


  /**
   * Navigates to the property horizontalPodAutoscaler so that assertions can be done on it
   */
  public HorizontalPodAutoscalerAssert horizontalPodAutoscaler()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (HorizontalPodAutoscalerAssert) assertThat(actual.getHorizontalPodAutoscaler()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "horizontalPodAutoscaler"));
  }


  /**
   * Navigates to the property horizontalPodAutoscalerList so that assertions can be done on it
   */
  public HorizontalPodAutoscalerListAssert horizontalPodAutoscalerList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (HorizontalPodAutoscalerListAssert) assertThat(actual.getHorizontalPodAutoscalerList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "horizontalPodAutoscalerList"));
  }


  /**
   * Navigates to the property horizontalPodAutoscalerSpec so that assertions can be done on it
   */
  public HorizontalPodAutoscalerSpecAssert horizontalPodAutoscalerSpec()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (HorizontalPodAutoscalerSpecAssert) assertThat(actual.getHorizontalPodAutoscalerSpec()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "horizontalPodAutoscalerSpec"));
  }


  /**
   * Navigates to the property identity so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.IdentityAssert identity()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.IdentityAssert) assertThat(actual.getIdentity()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "identity"));
  }


  /**
   * Navigates to the property identityList so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.IdentityListAssert identityList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.IdentityListAssert) assertThat(actual.getIdentityList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "identityList"));
  }


  /**
   * Navigates to the property imageList so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.ImageListAssert imageList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.ImageListAssert) assertThat(actual.getImageList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "imageList"));
  }


  /**
   * Navigates to the property imageStreamImport so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.ImageStreamImportAssert imageStreamImport()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.ImageStreamImportAssert) assertThat(actual.getImageStreamImport()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "imageStreamImport"));
  }


  /**
   * Navigates to the property imageStreamList so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.ImageStreamListAssert imageStreamList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.ImageStreamListAssert) assertThat(actual.getImageStreamList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "imageStreamList"));
  }


  /**
   * Navigates to the property imageStreamTagList so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.ImageStreamTagListAssert imageStreamTagList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.ImageStreamTagListAssert) assertThat(actual.getImageStreamTagList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "imageStreamTagList"));
  }


  /**
   * Navigates to the property info so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.version.InfoAssert info()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.version.InfoAssert) assertThat(actual.getInfo()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "info"));
  }


  /**
   * Navigates to the property ingress so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.extensions.IngressAssert ingress()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.extensions.IngressAssert) assertThat(actual.getIngress()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "ingress"));
  }


  /**
   * Navigates to the property ingressList so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.extensions.IngressListAssert ingressList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.extensions.IngressListAssert) assertThat(actual.getIngressList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "ingressList"));
  }


  /**
   * Navigates to the property jSONSchemaPropsorStringArray so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.apiextensions.JSONSchemaPropsOrStringArrayAssert jSONSchemaPropsorStringArray()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.apiextensions.JSONSchemaPropsOrStringArrayAssert) assertThat(actual.getJSONSchemaPropsorStringArray()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "jSONSchemaPropsorStringArray"));
  }


  /**
   * Navigates to the property job so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.batch.JobAssert job()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.batch.JobAssert) assertThat(actual.getJob()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "job"));
  }


  /**
   * Navigates to the property jobList so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.batch.JobListAssert jobList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.batch.JobListAssert) assertThat(actual.getJobList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "jobList"));
  }


  /**
   * Navigates to the property k8sLocalSubjectAccessReview so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.authorization.LocalSubjectAccessReviewAssert k8sLocalSubjectAccessReview()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.authorization.LocalSubjectAccessReviewAssert) assertThat(actual.getK8sLocalSubjectAccessReview()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "k8sLocalSubjectAccessReview"));
  }


  /**
   * Navigates to the property k8sSubjectAccessReview so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.authorization.SubjectAccessReviewAssert k8sSubjectAccessReview()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.authorization.SubjectAccessReviewAssert) assertThat(actual.getK8sSubjectAccessReview()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "k8sSubjectAccessReview"));
  }


  /**
   * Navigates to the property kubernetesRunAsUserStrategyOptions so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.policy.KubernetesRunAsUserStrategyOptionsAssert kubernetesRunAsUserStrategyOptions()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.policy.KubernetesRunAsUserStrategyOptionsAssert) assertThat(actual.getKubernetesRunAsUserStrategyOptions()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "kubernetesRunAsUserStrategyOptions"));
  }


  /**
   * Navigates to the property lease so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.coordination.v1.LeaseAssert lease()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.coordination.v1.LeaseAssert) assertThat(actual.getLease()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "lease"));
  }


  /**
   * Navigates to the property leaseList so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.coordination.v1.LeaseListAssert leaseList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.coordination.v1.LeaseListAssert) assertThat(actual.getLeaseList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "leaseList"));
  }


  /**
   * Navigates to the property limitRangeList so that assertions can be done on it
   */
  public LimitRangeListAssert limitRangeList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (LimitRangeListAssert) assertThat(actual.getLimitRangeList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "limitRangeList"));
  }


  /**
   * Navigates to the property listOptions so that assertions can be done on it
   */
  public ListOptionsAssert listOptions()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ListOptionsAssert) assertThat(actual.getListOptions()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "listOptions"));
  }


  /**
   * Navigates to the property localSubjectAccessReview so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.LocalSubjectAccessReviewAssert localSubjectAccessReview()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.LocalSubjectAccessReviewAssert) assertThat(actual.getLocalSubjectAccessReview()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "localSubjectAccessReview"));
  }


  /**
   * Navigates to the property mutatingWebhookConfiguration so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.admissionregistration.MutatingWebhookConfigurationAssert mutatingWebhookConfiguration()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.admissionregistration.MutatingWebhookConfigurationAssert) assertThat(actual.getMutatingWebhookConfiguration()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "mutatingWebhookConfiguration"));
  }


  /**
   * Navigates to the property mutatingWebhookConfigurationList so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.admissionregistration.MutatingWebhookConfigurationListAssert mutatingWebhookConfigurationList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.admissionregistration.MutatingWebhookConfigurationListAssert) assertThat(actual.getMutatingWebhookConfigurationList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "mutatingWebhookConfigurationList"));
  }


  /**
   * Navigates to the property namespace so that assertions can be done on it
   */
  public NamespaceAssert namespace()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (NamespaceAssert) assertThat(actual.getNamespace()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "namespace"));
  }


  /**
   * Navigates to the property namespaceList so that assertions can be done on it
   */
  public NamespaceListAssert namespaceList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (NamespaceListAssert) assertThat(actual.getNamespaceList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "namespaceList"));
  }


  /**
   * Navigates to the property netNamespace so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.NetNamespaceAssert netNamespace()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.NetNamespaceAssert) assertThat(actual.getNetNamespace()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "netNamespace"));
  }


  /**
   * Navigates to the property netNamespaceList so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.NetNamespaceListAssert netNamespaceList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.NetNamespaceListAssert) assertThat(actual.getNetNamespaceList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "netNamespaceList"));
  }


  /**
   * Navigates to the property networkPolicy so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.networking.NetworkPolicyAssert networkPolicy()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.networking.NetworkPolicyAssert) assertThat(actual.getNetworkPolicy()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "networkPolicy"));
  }


  /**
   * Navigates to the property networkPolicyList so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.networking.NetworkPolicyListAssert networkPolicyList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.networking.NetworkPolicyListAssert) assertThat(actual.getNetworkPolicyList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "networkPolicyList"));
  }


  /**
   * Navigates to the property node so that assertions can be done on it
   */
  public NodeAssert node()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (NodeAssert) assertThat(actual.getNode()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "node"));
  }


  /**
   * Navigates to the property nodeList so that assertions can be done on it
   */
  public NodeListAssert nodeList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (NodeListAssert) assertThat(actual.getNodeList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "nodeList"));
  }


  /**
   * Navigates to the property nodeMetrics so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.metrics.v1beta1.NodeMetricsAssert nodeMetrics()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.metrics.v1beta1.NodeMetricsAssert) assertThat(actual.getNodeMetrics()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "nodeMetrics"));
  }


  /**
   * Navigates to the property nodeMetricsList so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.metrics.v1beta1.NodeMetricsListAssert nodeMetricsList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.metrics.v1beta1.NodeMetricsListAssert) assertThat(actual.getNodeMetricsList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "nodeMetricsList"));
  }


  /**
   * Navigates to the property oAuthAccessToken so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.OAuthAccessTokenAssert oAuthAccessToken()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.OAuthAccessTokenAssert) assertThat(actual.getOAuthAccessToken()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "oAuthAccessToken"));
  }


  /**
   * Navigates to the property oAuthAccessTokenList so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.OAuthAccessTokenListAssert oAuthAccessTokenList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.OAuthAccessTokenListAssert) assertThat(actual.getOAuthAccessTokenList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "oAuthAccessTokenList"));
  }


  /**
   * Navigates to the property oAuthAuthorizeToken so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.OAuthAuthorizeTokenAssert oAuthAuthorizeToken()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.OAuthAuthorizeTokenAssert) assertThat(actual.getOAuthAuthorizeToken()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "oAuthAuthorizeToken"));
  }


  /**
   * Navigates to the property oAuthAuthorizeTokenList so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.OAuthAuthorizeTokenListAssert oAuthAuthorizeTokenList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.OAuthAuthorizeTokenListAssert) assertThat(actual.getOAuthAuthorizeTokenList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "oAuthAuthorizeTokenList"));
  }


  /**
   * Navigates to the property oAuthClient so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.OAuthClientAssert oAuthClient()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.OAuthClientAssert) assertThat(actual.getOAuthClient()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "oAuthClient"));
  }


  /**
   * Navigates to the property oAuthClientAuthorization so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.OAuthClientAuthorizationAssert oAuthClientAuthorization()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.OAuthClientAuthorizationAssert) assertThat(actual.getOAuthClientAuthorization()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "oAuthClientAuthorization"));
  }


  /**
   * Navigates to the property oAuthClientAuthorizationList so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.OAuthClientAuthorizationListAssert oAuthClientAuthorizationList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.OAuthClientAuthorizationListAssert) assertThat(actual.getOAuthClientAuthorizationList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "oAuthClientAuthorizationList"));
  }


  /**
   * Navigates to the property oAuthClientList so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.OAuthClientListAssert oAuthClientList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.OAuthClientListAssert) assertThat(actual.getOAuthClientList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "oAuthClientList"));
  }


  /**
   * Navigates to the property objectMeta so that assertions can be done on it
   */
  public ObjectMetaAssert objectMeta()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ObjectMetaAssert) assertThat(actual.getObjectMeta()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "objectMeta"));
  }


  /**
   * Navigates to the property openshiftClusterRole so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.OpenshiftClusterRoleAssert openshiftClusterRole()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.OpenshiftClusterRoleAssert) assertThat(actual.getOpenshiftClusterRole()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "openshiftClusterRole"));
  }


  /**
   * Navigates to the property openshiftClusterRoleBinding so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.OpenshiftClusterRoleBindingAssert openshiftClusterRoleBinding()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.OpenshiftClusterRoleBindingAssert) assertThat(actual.getOpenshiftClusterRoleBinding()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "openshiftClusterRoleBinding"));
  }


  /**
   * Navigates to the property openshiftClusterRoleBindingList so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.OpenshiftClusterRoleBindingListAssert openshiftClusterRoleBindingList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.OpenshiftClusterRoleBindingListAssert) assertThat(actual.getOpenshiftClusterRoleBindingList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "openshiftClusterRoleBindingList"));
  }


  /**
   * Navigates to the property openshiftClusterRoleScopeRestriction so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.OpenshiftClusterRoleScopeRestrictionAssert openshiftClusterRoleScopeRestriction()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.OpenshiftClusterRoleScopeRestrictionAssert) assertThat(actual.getOpenshiftClusterRoleScopeRestriction()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "openshiftClusterRoleScopeRestriction"));
  }


  /**
   * Navigates to the property openshiftRole so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.OpenshiftRoleAssert openshiftRole()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.OpenshiftRoleAssert) assertThat(actual.getOpenshiftRole()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "openshiftRole"));
  }


  /**
   * Navigates to the property openshiftRoleBinding so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.OpenshiftRoleBindingAssert openshiftRoleBinding()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.OpenshiftRoleBindingAssert) assertThat(actual.getOpenshiftRoleBinding()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "openshiftRoleBinding"));
  }


  /**
   * Navigates to the property openshiftRoleBindingList so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.OpenshiftRoleBindingListAssert openshiftRoleBindingList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.OpenshiftRoleBindingListAssert) assertThat(actual.getOpenshiftRoleBindingList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "openshiftRoleBindingList"));
  }


  /**
   * Navigates to the property openshiftRoleBindingRestriction so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.OpenshiftRoleBindingRestrictionAssert openshiftRoleBindingRestriction()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.OpenshiftRoleBindingRestrictionAssert) assertThat(actual.getOpenshiftRoleBindingRestriction()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "openshiftRoleBindingRestriction"));
  }


  /**
   * Navigates to the property openshiftRoleBindingRestrictionSpec so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.OpenshiftRoleBindingRestrictionSpecAssert openshiftRoleBindingRestrictionSpec()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.OpenshiftRoleBindingRestrictionSpecAssert) assertThat(actual.getOpenshiftRoleBindingRestrictionSpec()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "openshiftRoleBindingRestrictionSpec"));
  }


  /**
   * Navigates to the property openshiftRoleList so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.OpenshiftRoleListAssert openshiftRoleList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.OpenshiftRoleListAssert) assertThat(actual.getOpenshiftRoleList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "openshiftRoleList"));
  }


  /**
   * Navigates to the property operation so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert operation()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getOperation()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "operation"));
  }


  /**
   * Navigates to the property patch so that assertions can be done on it
   */
  public PatchAssert patch()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (PatchAssert) assertThat(actual.getPatch()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "patch"));
  }


  /**
   * Navigates to the property patchOptions so that assertions can be done on it
   */
  public PatchOptionsAssert patchOptions()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (PatchOptionsAssert) assertThat(actual.getPatchOptions()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "patchOptions"));
  }


  /**
   * Navigates to the property patchType so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert patchType()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getPatchType()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "patchType"));
  }


  /**
   * Navigates to the property persistentVolume so that assertions can be done on it
   */
  public PersistentVolumeAssert persistentVolume()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (PersistentVolumeAssert) assertThat(actual.getPersistentVolume()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "persistentVolume"));
  }


  /**
   * Navigates to the property persistentVolumeClaim so that assertions can be done on it
   */
  public PersistentVolumeClaimAssert persistentVolumeClaim()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (PersistentVolumeClaimAssert) assertThat(actual.getPersistentVolumeClaim()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "persistentVolumeClaim"));
  }


  /**
   * Navigates to the property persistentVolumeClaimList so that assertions can be done on it
   */
  public PersistentVolumeClaimListAssert persistentVolumeClaimList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (PersistentVolumeClaimListAssert) assertThat(actual.getPersistentVolumeClaimList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "persistentVolumeClaimList"));
  }


  /**
   * Navigates to the property persistentVolumeList so that assertions can be done on it
   */
  public PersistentVolumeListAssert persistentVolumeList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (PersistentVolumeListAssert) assertThat(actual.getPersistentVolumeList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "persistentVolumeList"));
  }


  /**
   * Navigates to the property podDisruptionBudget so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.policy.PodDisruptionBudgetAssert podDisruptionBudget()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.policy.PodDisruptionBudgetAssert) assertThat(actual.getPodDisruptionBudget()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "podDisruptionBudget"));
  }


  /**
   * Navigates to the property podDisruptionBudgetList so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.policy.PodDisruptionBudgetListAssert podDisruptionBudgetList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.policy.PodDisruptionBudgetListAssert) assertThat(actual.getPodDisruptionBudgetList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "podDisruptionBudgetList"));
  }


  /**
   * Navigates to the property podList so that assertions can be done on it
   */
  public PodListAssert podList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (PodListAssert) assertThat(actual.getPodList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "podList"));
  }


  /**
   * Navigates to the property podMetrics so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetricsAssert podMetrics()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetricsAssert) assertThat(actual.getPodMetrics()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "podMetrics"));
  }


  /**
   * Navigates to the property podMetricsList so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetricsListAssert podMetricsList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetricsListAssert) assertThat(actual.getPodMetricsList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "podMetricsList"));
  }


  /**
   * Navigates to the property podPreset so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.settings.PodPresetAssert podPreset()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.settings.PodPresetAssert) assertThat(actual.getPodPreset()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "podPreset"));
  }


  /**
   * Navigates to the property podPresetList so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.settings.PodPresetListAssert podPresetList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.settings.PodPresetListAssert) assertThat(actual.getPodPresetList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "podPresetList"));
  }


  /**
   * Navigates to the property podPresetSpec so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.settings.PodPresetSpecAssert podPresetSpec()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.settings.PodPresetSpecAssert) assertThat(actual.getPodPresetSpec()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "podPresetSpec"));
  }


  /**
   * Navigates to the property podSecurityPolicy so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.policy.PodSecurityPolicyAssert podSecurityPolicy()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.policy.PodSecurityPolicyAssert) assertThat(actual.getPodSecurityPolicy()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "podSecurityPolicy"));
  }


  /**
   * Navigates to the property podSecurityPolicyList so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.policy.PodSecurityPolicyListAssert podSecurityPolicyList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.policy.PodSecurityPolicyListAssert) assertThat(actual.getPodSecurityPolicyList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "podSecurityPolicyList"));
  }


  /**
   * Navigates to the property podTemplateList so that assertions can be done on it
   */
  public PodTemplateListAssert podTemplateList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (PodTemplateListAssert) assertThat(actual.getPodTemplateList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "podTemplateList"));
  }


  /**
   * Navigates to the property priorityClass so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.scheduling.PriorityClassAssert priorityClass()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.scheduling.PriorityClassAssert) assertThat(actual.getPriorityClass()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "priorityClass"));
  }


  /**
   * Navigates to the property priorityClassList so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.scheduling.PriorityClassListAssert priorityClassList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.scheduling.PriorityClassListAssert) assertThat(actual.getPriorityClassList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "priorityClassList"));
  }


  /**
   * Navigates to the property project so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.ProjectAssert project()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.ProjectAssert) assertThat(actual.getProject()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "project"));
  }


  /**
   * Navigates to the property projectList so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.ProjectListAssert projectList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.ProjectListAssert) assertThat(actual.getProjectList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "projectList"));
  }


  /**
   * Navigates to the property projectRequest so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.ProjectRequestAssert projectRequest()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.ProjectRequestAssert) assertThat(actual.getProjectRequest()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "projectRequest"));
  }


  /**
   * Navigates to the property quantity so that assertions can be done on it
   */
  public QuantityAssert quantity()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (QuantityAssert) assertThat(actual.getQuantity()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "quantity"));
  }


  /**
   * Navigates to the property replicaSet so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.apps.ReplicaSetAssert replicaSet()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.apps.ReplicaSetAssert) assertThat(actual.getReplicaSet()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "replicaSet"));
  }


  /**
   * Navigates to the property replicaSetList so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.apps.ReplicaSetListAssert replicaSetList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.apps.ReplicaSetListAssert) assertThat(actual.getReplicaSetList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "replicaSetList"));
  }


  /**
   * Navigates to the property replicationControllerList so that assertions can be done on it
   */
  public ReplicationControllerListAssert replicationControllerList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ReplicationControllerListAssert) assertThat(actual.getReplicationControllerList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "replicationControllerList"));
  }


  /**
   * Navigates to the property resourceQuota so that assertions can be done on it
   */
  public ResourceQuotaAssert resourceQuota()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ResourceQuotaAssert) assertThat(actual.getResourceQuota()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "resourceQuota"));
  }


  /**
   * Navigates to the property resourceQuotaList so that assertions can be done on it
   */
  public ResourceQuotaListAssert resourceQuotaList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ResourceQuotaListAssert) assertThat(actual.getResourceQuotaList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "resourceQuotaList"));
  }


  /**
   * Navigates to the property role so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.rbac.RoleAssert role()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.rbac.RoleAssert) assertThat(actual.getRole()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "role"));
  }


  /**
   * Navigates to the property roleBinding so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.rbac.RoleBindingAssert roleBinding()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.rbac.RoleBindingAssert) assertThat(actual.getRoleBinding()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "roleBinding"));
  }


  /**
   * Navigates to the property roleBindingList so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.rbac.RoleBindingListAssert roleBindingList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.rbac.RoleBindingListAssert) assertThat(actual.getRoleBindingList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "roleBindingList"));
  }


  /**
   * Navigates to the property roleList so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.rbac.RoleListAssert roleList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.rbac.RoleListAssert) assertThat(actual.getRoleList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "roleList"));
  }


  /**
   * Navigates to the property rootPaths so that assertions can be done on it
   */
  public RootPathsAssert rootPaths()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (RootPathsAssert) assertThat(actual.getRootPaths()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "rootPaths"));
  }


  /**
   * Navigates to the property route so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.RouteAssert route()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.RouteAssert) assertThat(actual.getRoute()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "route"));
  }


  /**
   * Navigates to the property routeList so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.RouteListAssert routeList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.RouteListAssert) assertThat(actual.getRouteList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "routeList"));
  }


  /**
   * Navigates to the property rule so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.admissionregistration.RuleAssert rule()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.admissionregistration.RuleAssert) assertThat(actual.getRule()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "rule"));
  }


  /**
   * Navigates to the property ruleWithOperations so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.admissionregistration.RuleWithOperationsAssert ruleWithOperations()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.admissionregistration.RuleWithOperationsAssert) assertThat(actual.getRuleWithOperations()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "ruleWithOperations"));
  }


  /**
   * Navigates to the property scale so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.v1.ScaleAssert scale()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.v1.ScaleAssert) assertThat(actual.getScale()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "scale"));
  }


  /**
   * Navigates to the property secret so that assertions can be done on it
   */
  public SecretAssert secret()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (SecretAssert) assertThat(actual.getSecret()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "secret"));
  }


  /**
   * Navigates to the property secretList so that assertions can be done on it
   */
  public SecretListAssert secretList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (SecretListAssert) assertThat(actual.getSecretList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "secretList"));
  }


  /**
   * Navigates to the property securityContextConstraints so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.SecurityContextConstraintsAssert securityContextConstraints()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.SecurityContextConstraintsAssert) assertThat(actual.getSecurityContextConstraints()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "securityContextConstraints"));
  }


  /**
   * Navigates to the property securityContextConstraintsList so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.SecurityContextConstraintsListAssert securityContextConstraintsList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.SecurityContextConstraintsListAssert) assertThat(actual.getSecurityContextConstraintsList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "securityContextConstraintsList"));
  }


  /**
   * Navigates to the property selfSubjectAccessReview so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.authorization.SelfSubjectAccessReviewAssert selfSubjectAccessReview()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.authorization.SelfSubjectAccessReviewAssert) assertThat(actual.getSelfSubjectAccessReview()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "selfSubjectAccessReview"));
  }


  /**
   * Navigates to the property selfSubjectRulesReview so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.authorization.SelfSubjectRulesReviewAssert selfSubjectRulesReview()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.authorization.SelfSubjectRulesReviewAssert) assertThat(actual.getSelfSubjectRulesReview()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "selfSubjectRulesReview"));
  }


  /**
   * Navigates to the property serviceAccount so that assertions can be done on it
   */
  public ServiceAccountAssert serviceAccount()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ServiceAccountAssert) assertThat(actual.getServiceAccount()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "serviceAccount"));
  }


  /**
   * Navigates to the property serviceAccountList so that assertions can be done on it
   */
  public ServiceAccountListAssert serviceAccountList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ServiceAccountListAssert) assertThat(actual.getServiceAccountList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "serviceAccountList"));
  }


  /**
   * Navigates to the property serviceList so that assertions can be done on it
   */
  public ServiceListAssert serviceList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ServiceListAssert) assertThat(actual.getServiceList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "serviceList"));
  }


  /**
   * Navigates to the property serviceReference so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.admissionregistration.ServiceReferenceAssert serviceReference()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.admissionregistration.ServiceReferenceAssert) assertThat(actual.getServiceReference()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "serviceReference"));
  }


  /**
   * Navigates to the property statefulSet so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.apps.StatefulSetAssert statefulSet()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.apps.StatefulSetAssert) assertThat(actual.getStatefulSet()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "statefulSet"));
  }


  /**
   * Navigates to the property statefulSetList so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.apps.StatefulSetListAssert statefulSetList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.apps.StatefulSetListAssert) assertThat(actual.getStatefulSetList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "statefulSetList"));
  }


  /**
   * Navigates to the property status so that assertions can be done on it
   */
  public StatusAssert status()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (StatusAssert) assertThat(actual.getStatus()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "status"));
  }


  /**
   * Navigates to the property storageClass so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.storage.StorageClassAssert storageClass()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.storage.StorageClassAssert) assertThat(actual.getStorageClass()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "storageClass"));
  }


  /**
   * Navigates to the property storageClassList so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.storage.StorageClassListAssert storageClassList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.storage.StorageClassListAssert) assertThat(actual.getStorageClassList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "storageClassList"));
  }


  /**
   * Navigates to the property subjectAccessReview so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.SubjectAccessReviewAssert subjectAccessReview()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.SubjectAccessReviewAssert) assertThat(actual.getSubjectAccessReview()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "subjectAccessReview"));
  }


  /**
   * Navigates to the property subjectAccessReviewResponse so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.SubjectAccessReviewResponseAssert subjectAccessReviewResponse()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.SubjectAccessReviewResponseAssert) assertThat(actual.getSubjectAccessReviewResponse()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "subjectAccessReviewResponse"));
  }


  /**
   * Navigates to the property tagEvent so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.TagEventAssert tagEvent()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.TagEventAssert) assertThat(actual.getTagEvent()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "tagEvent"));
  }


  /**
   * Navigates to the property template so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.TemplateAssert template()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.TemplateAssert) assertThat(actual.getTemplate()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "template"));
  }


  /**
   * Navigates to the property templateList so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.TemplateListAssert templateList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.TemplateListAssert) assertThat(actual.getTemplateList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "templateList"));
  }


  /**
   * Navigates to the property time so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert time()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getTime()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "time"));
  }


  /**
   * Navigates to the property tokenReview so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.authentication.TokenReviewAssert tokenReview()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.authentication.TokenReviewAssert) assertThat(actual.getTokenReview()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "tokenReview"));
  }


  /**
   * Navigates to the property toleration so that assertions can be done on it
   */
  public TolerationAssert toleration()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (TolerationAssert) assertThat(actual.getToleration()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "toleration"));
  }


  /**
   * Navigates to the property typeMeta so that assertions can be done on it
   */
  public TypeMetaAssert typeMeta()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (TypeMetaAssert) assertThat(actual.getTypeMeta()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "typeMeta"));
  }


  /**
   * Navigates to the property updateOptions so that assertions can be done on it
   */
  public UpdateOptionsAssert updateOptions()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (UpdateOptionsAssert) assertThat(actual.getUpdateOptions()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "updateOptions"));
  }


  /**
   * Navigates to the property user so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.UserAssert user()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.UserAssert) assertThat(actual.getUser()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "user"));
  }


  /**
   * Navigates to the property userList so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.UserListAssert userList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.UserListAssert) assertThat(actual.getUserList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "userList"));
  }


  /**
   * Navigates to the property validatingWebhookConfiguration so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.admissionregistration.ValidatingWebhookConfigurationAssert validatingWebhookConfiguration()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.admissionregistration.ValidatingWebhookConfigurationAssert) assertThat(actual.getValidatingWebhookConfiguration()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "validatingWebhookConfiguration"));
  }


  /**
   * Navigates to the property validatingWebhookConfigurationList so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.admissionregistration.ValidatingWebhookConfigurationListAssert validatingWebhookConfigurationList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.admissionregistration.ValidatingWebhookConfigurationListAssert) assertThat(actual.getValidatingWebhookConfigurationList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "validatingWebhookConfigurationList"));
  }


  /**
   * Navigates to the property volumeAttachment so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.storage.VolumeAttachmentAssert volumeAttachment()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.storage.VolumeAttachmentAssert) assertThat(actual.getVolumeAttachment()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "volumeAttachment"));
  }


  /**
   * Navigates to the property volumeAttachmentList so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.storage.VolumeAttachmentListAssert volumeAttachmentList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.storage.VolumeAttachmentListAssert) assertThat(actual.getVolumeAttachmentList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "volumeAttachmentList"));
  }


  /**
   * Navigates to the property watchEvent so that assertions can be done on it
   */
  public WatchEventAssert watchEvent()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (WatchEventAssert) assertThat(actual.getWatchEvent()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "watchEvent"));
  }


}
