package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link ISCSIVolumeSource} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractISCSIVolumeSourceAssert<S extends AbstractISCSIVolumeSourceAssert<S, A>, A extends ISCSIVolumeSource> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractISCSIVolumeSourceAssert}</code> to make assertions on actual ISCSIVolumeSource.
   * @param actual the ISCSIVolumeSource we want to make assertions on.
   */
  protected AbstractISCSIVolumeSourceAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual ISCSIVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property chapAuthDiscovery so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert chapAuthDiscovery()  {
    // check that actual ISCSIVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getChapAuthDiscovery()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "chapAuthDiscovery"));
  }


  /**
   * Navigates to the property chapAuthSession so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert chapAuthSession()  {
    // check that actual ISCSIVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getChapAuthSession()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "chapAuthSession"));
  }


  /**
   * Navigates to the property fsType so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert fsType()  {
    // check that actual ISCSIVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getFsType()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "fsType"));
  }


  /**
   * Navigates to the property initiatorName so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert initiatorName()  {
    // check that actual ISCSIVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getInitiatorName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "initiatorName"));
  }


  /**
   * Navigates to the property iqn so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert iqn()  {
    // check that actual ISCSIVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getIqn()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "iqn"));
  }


  /**
   * Navigates to the property iscsiInterface so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert iscsiInterface()  {
    // check that actual ISCSIVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getIscsiInterface()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "iscsiInterface"));
  }


  /**
   * Verifies that the actual ISCSIVolumeSource's lun is equal to the given one.
   * @param lun the given lun to compare the actual ISCSIVolumeSource's lun to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ISCSIVolumeSource's lun is not equal to the given one.
   */
  public S hasLun(Integer lun) {
    // check that actual ISCSIVolumeSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting lun of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualLun = actual.getLun();
    if (!Objects.areEqual(actualLun, lun)) {
      failWithMessage(assertjErrorMessage, actual, lun, actualLun);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property portals so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> portals()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getPortals(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "portals"));
    return answer;
  }


  /**
   * Navigates to the property readOnly so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert readOnly()  {
    // check that actual ISCSIVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getReadOnly()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "readOnly"));
  }


  /**
   * Navigates to the property secretRef so that assertions can be done on it
   */
  public LocalObjectReferenceAssert secretRef()  {
    // check that actual ISCSIVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (LocalObjectReferenceAssert) assertThat(actual.getSecretRef()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "secretRef"));
  }


  /**
   * Navigates to the property targetPortal so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert targetPortal()  {
    // check that actual ISCSIVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getTargetPortal()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "targetPortal"));
  }


}
