package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link HTTPGetAction} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractHTTPGetActionAssert<S extends AbstractHTTPGetActionAssert<S, A>, A extends HTTPGetAction> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractHTTPGetActionAssert}</code> to make assertions on actual HTTPGetAction.
   * @param actual the HTTPGetAction we want to make assertions on.
   */
  protected AbstractHTTPGetActionAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual HTTPGetAction we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property host so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert host()  {
    // check that actual HTTPGetAction we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getHost()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "host"));
  }


  /**
   * Navigates to the property httpHeaders so that assertions can be done on it
   */
  public NavigationListAssert<HTTPHeader, HTTPHeaderAssert> httpHeaders()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<HTTPHeader, HTTPHeaderAssert> assertFactory = new AssertFactory<HTTPHeader, HTTPHeaderAssert>() {
      public HTTPHeaderAssert createAssert(HTTPHeader t) {
        return (HTTPHeaderAssert) assertThat(t);
      }
    };
    NavigationListAssert<HTTPHeader, HTTPHeaderAssert> answer = new NavigationListAssert<HTTPHeader, HTTPHeaderAssert>(actual.getHttpHeaders(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "httpHeaders"));
    return answer;
  }


  /**
   * Navigates to the property path so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert path()  {
    // check that actual HTTPGetAction we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getPath()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "path"));
  }


  /**
   * Navigates to the property port so that assertions can be done on it
   */
  public IntOrStringAssert port()  {
    // check that actual HTTPGetAction we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (IntOrStringAssert) assertThat(actual.getPort()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "port"));
  }


  /**
   * Navigates to the property scheme so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert scheme()  {
    // check that actual HTTPGetAction we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getScheme()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "scheme"));
  }


}
