package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link GroupVersionKind} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractGroupVersionKindAssert<S extends AbstractGroupVersionKindAssert<S, A>, A extends GroupVersionKind> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractGroupVersionKindAssert}</code> to make assertions on actual GroupVersionKind.
   * @param actual the GroupVersionKind we want to make assertions on.
   */
  protected AbstractGroupVersionKindAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual GroupVersionKind we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property group so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert group()  {
    // check that actual GroupVersionKind we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getGroup()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "group"));
  }


  /**
   * Navigates to the property kind so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert kind()  {
    // check that actual GroupVersionKind we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getKind()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "kind"));
  }


  /**
   * Navigates to the property version so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert version()  {
    // check that actual GroupVersionKind we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "version"));
  }


}
