package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link GroupVersionForDiscovery} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractGroupVersionForDiscoveryAssert<S extends AbstractGroupVersionForDiscoveryAssert<S, A>, A extends GroupVersionForDiscovery> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractGroupVersionForDiscoveryAssert}</code> to make assertions on actual GroupVersionForDiscovery.
   * @param actual the GroupVersionForDiscovery we want to make assertions on.
   */
  protected AbstractGroupVersionForDiscoveryAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual GroupVersionForDiscovery we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property groupVersion so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert groupVersion()  {
    // check that actual GroupVersionForDiscovery we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getGroupVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "groupVersion"));
  }


  /**
   * Navigates to the property version so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert version()  {
    // check that actual GroupVersionForDiscovery we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "version"));
  }


}
