package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link GlusterfsPersistentVolumeSource} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractGlusterfsPersistentVolumeSourceAssert<S extends AbstractGlusterfsPersistentVolumeSourceAssert<S, A>, A extends GlusterfsPersistentVolumeSource> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractGlusterfsPersistentVolumeSourceAssert}</code> to make assertions on actual GlusterfsPersistentVolumeSource.
   * @param actual the GlusterfsPersistentVolumeSource we want to make assertions on.
   */
  protected AbstractGlusterfsPersistentVolumeSourceAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual GlusterfsPersistentVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property endpoints so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert endpoints()  {
    // check that actual GlusterfsPersistentVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getEndpoints()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "endpoints"));
  }


  /**
   * Navigates to the property endpointsNamespace so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert endpointsNamespace()  {
    // check that actual GlusterfsPersistentVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getEndpointsNamespace()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "endpointsNamespace"));
  }


  /**
   * Navigates to the property path so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert path()  {
    // check that actual GlusterfsPersistentVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getPath()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "path"));
  }


  /**
   * Navigates to the property readOnly so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert readOnly()  {
    // check that actual GlusterfsPersistentVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getReadOnly()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "readOnly"));
  }


}
