package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link ExecConfig} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractExecConfigAssert<S extends AbstractExecConfigAssert<S, A>, A extends ExecConfig> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractExecConfigAssert}</code> to make assertions on actual ExecConfig.
   * @param actual the ExecConfig we want to make assertions on.
   */
  protected AbstractExecConfigAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual ExecConfig we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property apiVersion so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert apiVersion()  {
    // check that actual ExecConfig we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getApiVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "apiVersion"));
  }


  /**
   * Navigates to the property args so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> args()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getArgs(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "args"));
    return answer;
  }


  /**
   * Navigates to the property command so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert command()  {
    // check that actual ExecConfig we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getCommand()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "command"));
  }


  /**
   * Navigates to the property env so that assertions can be done on it
   */
  public NavigationListAssert<ExecEnvVar, ExecEnvVarAssert> env()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<ExecEnvVar, ExecEnvVarAssert> assertFactory = new AssertFactory<ExecEnvVar, ExecEnvVarAssert>() {
      public ExecEnvVarAssert createAssert(ExecEnvVar t) {
        return (ExecEnvVarAssert) assertThat(t);
      }
    };
    NavigationListAssert<ExecEnvVar, ExecEnvVarAssert> answer = new NavigationListAssert<ExecEnvVar, ExecEnvVarAssert>(actual.getEnv(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "env"));
    return answer;
  }


}
