package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link EventSource} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractEventSourceAssert<S extends AbstractEventSourceAssert<S, A>, A extends EventSource> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractEventSourceAssert}</code> to make assertions on actual EventSource.
   * @param actual the EventSource we want to make assertions on.
   */
  protected AbstractEventSourceAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual EventSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property component so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert component()  {
    // check that actual EventSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getComponent()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "component"));
  }


  /**
   * Navigates to the property host so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert host()  {
    // check that actual EventSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getHost()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "host"));
  }


}
