package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link EphemeralContainer} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractEphemeralContainerAssert<S extends AbstractEphemeralContainerAssert<S, A>, A extends EphemeralContainer> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractEphemeralContainerAssert}</code> to make assertions on actual EphemeralContainer.
   * @param actual the EphemeralContainer we want to make assertions on.
   */
  protected AbstractEphemeralContainerAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual EphemeralContainer we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property args so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> args()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getArgs(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "args"));
    return answer;
  }


  /**
   * Navigates to the property command so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> command()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getCommand(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "command"));
    return answer;
  }


  /**
   * Navigates to the property env so that assertions can be done on it
   */
  public NavigationListAssert<EnvVar, EnvVarAssert> env()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<EnvVar, EnvVarAssert> assertFactory = new AssertFactory<EnvVar, EnvVarAssert>() {
      public EnvVarAssert createAssert(EnvVar t) {
        return (EnvVarAssert) assertThat(t);
      }
    };
    NavigationListAssert<EnvVar, EnvVarAssert> answer = new NavigationListAssert<EnvVar, EnvVarAssert>(actual.getEnv(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "env"));
    return answer;
  }


  /**
   * Navigates to the property envFrom so that assertions can be done on it
   */
  public NavigationListAssert<EnvFromSource, EnvFromSourceAssert> envFrom()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<EnvFromSource, EnvFromSourceAssert> assertFactory = new AssertFactory<EnvFromSource, EnvFromSourceAssert>() {
      public EnvFromSourceAssert createAssert(EnvFromSource t) {
        return (EnvFromSourceAssert) assertThat(t);
      }
    };
    NavigationListAssert<EnvFromSource, EnvFromSourceAssert> answer = new NavigationListAssert<EnvFromSource, EnvFromSourceAssert>(actual.getEnvFrom(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "envFrom"));
    return answer;
  }


  /**
   * Navigates to the property image so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert image()  {
    // check that actual EphemeralContainer we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getImage()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "image"));
  }


  /**
   * Navigates to the property imagePullPolicy so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert imagePullPolicy()  {
    // check that actual EphemeralContainer we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getImagePullPolicy()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "imagePullPolicy"));
  }


  /**
   * Navigates to the property lifecycle so that assertions can be done on it
   */
  public LifecycleAssert lifecycle()  {
    // check that actual EphemeralContainer we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (LifecycleAssert) assertThat(actual.getLifecycle()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "lifecycle"));
  }


  /**
   * Navigates to the property livenessProbe so that assertions can be done on it
   */
  public ProbeAssert livenessProbe()  {
    // check that actual EphemeralContainer we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ProbeAssert) assertThat(actual.getLivenessProbe()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "livenessProbe"));
  }


  /**
   * Navigates to the property name so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert name()  {
    // check that actual EphemeralContainer we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "name"));
  }


  /**
   * Navigates to the property ports so that assertions can be done on it
   */
  public NavigationListAssert<ContainerPort, ContainerPortAssert> ports()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<ContainerPort, ContainerPortAssert> assertFactory = new AssertFactory<ContainerPort, ContainerPortAssert>() {
      public ContainerPortAssert createAssert(ContainerPort t) {
        return (ContainerPortAssert) assertThat(t);
      }
    };
    NavigationListAssert<ContainerPort, ContainerPortAssert> answer = new NavigationListAssert<ContainerPort, ContainerPortAssert>(actual.getPorts(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "ports"));
    return answer;
  }


  /**
   * Navigates to the property readinessProbe so that assertions can be done on it
   */
  public ProbeAssert readinessProbe()  {
    // check that actual EphemeralContainer we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ProbeAssert) assertThat(actual.getReadinessProbe()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "readinessProbe"));
  }


  /**
   * Navigates to the property resources so that assertions can be done on it
   */
  public ResourceRequirementsAssert resources()  {
    // check that actual EphemeralContainer we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ResourceRequirementsAssert) assertThat(actual.getResources()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "resources"));
  }


  /**
   * Navigates to the property securityContext so that assertions can be done on it
   */
  public SecurityContextAssert securityContext()  {
    // check that actual EphemeralContainer we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (SecurityContextAssert) assertThat(actual.getSecurityContext()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "securityContext"));
  }


  /**
   * Navigates to the property startupProbe so that assertions can be done on it
   */
  public ProbeAssert startupProbe()  {
    // check that actual EphemeralContainer we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ProbeAssert) assertThat(actual.getStartupProbe()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "startupProbe"));
  }


  /**
   * Navigates to the property stdin so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert stdin()  {
    // check that actual EphemeralContainer we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getStdin()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "stdin"));
  }


  /**
   * Navigates to the property stdinOnce so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert stdinOnce()  {
    // check that actual EphemeralContainer we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getStdinOnce()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "stdinOnce"));
  }


  /**
   * Navigates to the property targetContainerName so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert targetContainerName()  {
    // check that actual EphemeralContainer we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getTargetContainerName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "targetContainerName"));
  }


  /**
   * Navigates to the property terminationMessagePath so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert terminationMessagePath()  {
    // check that actual EphemeralContainer we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getTerminationMessagePath()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "terminationMessagePath"));
  }


  /**
   * Navigates to the property terminationMessagePolicy so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert terminationMessagePolicy()  {
    // check that actual EphemeralContainer we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getTerminationMessagePolicy()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "terminationMessagePolicy"));
  }


  /**
   * Navigates to the property tty so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert tty()  {
    // check that actual EphemeralContainer we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getTty()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "tty"));
  }


  /**
   * Navigates to the property volumeDevices so that assertions can be done on it
   */
  public NavigationListAssert<VolumeDevice, VolumeDeviceAssert> volumeDevices()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<VolumeDevice, VolumeDeviceAssert> assertFactory = new AssertFactory<VolumeDevice, VolumeDeviceAssert>() {
      public VolumeDeviceAssert createAssert(VolumeDevice t) {
        return (VolumeDeviceAssert) assertThat(t);
      }
    };
    NavigationListAssert<VolumeDevice, VolumeDeviceAssert> answer = new NavigationListAssert<VolumeDevice, VolumeDeviceAssert>(actual.getVolumeDevices(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "volumeDevices"));
    return answer;
  }


  /**
   * Navigates to the property volumeMounts so that assertions can be done on it
   */
  public NavigationListAssert<VolumeMount, VolumeMountAssert> volumeMounts()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<VolumeMount, VolumeMountAssert> assertFactory = new AssertFactory<VolumeMount, VolumeMountAssert>() {
      public VolumeMountAssert createAssert(VolumeMount t) {
        return (VolumeMountAssert) assertThat(t);
      }
    };
    NavigationListAssert<VolumeMount, VolumeMountAssert> answer = new NavigationListAssert<VolumeMount, VolumeMountAssert>(actual.getVolumeMounts(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "volumeMounts"));
    return answer;
  }


  /**
   * Navigates to the property workingDir so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert workingDir()  {
    // check that actual EphemeralContainer we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getWorkingDir()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "workingDir"));
  }


}
