package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link EnvFromSource} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractEnvFromSourceAssert<S extends AbstractEnvFromSourceAssert<S, A>, A extends EnvFromSource> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractEnvFromSourceAssert}</code> to make assertions on actual EnvFromSource.
   * @param actual the EnvFromSource we want to make assertions on.
   */
  protected AbstractEnvFromSourceAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual EnvFromSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property configMapRef so that assertions can be done on it
   */
  public ConfigMapEnvSourceAssert configMapRef()  {
    // check that actual EnvFromSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ConfigMapEnvSourceAssert) assertThat(actual.getConfigMapRef()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "configMapRef"));
  }


  /**
   * Navigates to the property prefix so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert prefix()  {
    // check that actual EnvFromSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getPrefix()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "prefix"));
  }


  /**
   * Navigates to the property secretRef so that assertions can be done on it
   */
  public SecretEnvSourceAssert secretRef()  {
    // check that actual EnvFromSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (SecretEnvSourceAssert) assertThat(actual.getSecretRef()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "secretRef"));
  }


}
