package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link EndpointSubset} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractEndpointSubsetAssert<S extends AbstractEndpointSubsetAssert<S, A>, A extends EndpointSubset> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractEndpointSubsetAssert}</code> to make assertions on actual EndpointSubset.
   * @param actual the EndpointSubset we want to make assertions on.
   */
  protected AbstractEndpointSubsetAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual EndpointSubset we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property addresses so that assertions can be done on it
   */
  public NavigationListAssert<EndpointAddress, EndpointAddressAssert> addresses()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<EndpointAddress, EndpointAddressAssert> assertFactory = new AssertFactory<EndpointAddress, EndpointAddressAssert>() {
      public EndpointAddressAssert createAssert(EndpointAddress t) {
        return (EndpointAddressAssert) assertThat(t);
      }
    };
    NavigationListAssert<EndpointAddress, EndpointAddressAssert> answer = new NavigationListAssert<EndpointAddress, EndpointAddressAssert>(actual.getAddresses(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "addresses"));
    return answer;
  }


  /**
   * Navigates to the property notReadyAddresses so that assertions can be done on it
   */
  public NavigationListAssert<EndpointAddress, EndpointAddressAssert> notReadyAddresses()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<EndpointAddress, EndpointAddressAssert> assertFactory = new AssertFactory<EndpointAddress, EndpointAddressAssert>() {
      public EndpointAddressAssert createAssert(EndpointAddress t) {
        return (EndpointAddressAssert) assertThat(t);
      }
    };
    NavigationListAssert<EndpointAddress, EndpointAddressAssert> answer = new NavigationListAssert<EndpointAddress, EndpointAddressAssert>(actual.getNotReadyAddresses(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "notReadyAddresses"));
    return answer;
  }


  /**
   * Navigates to the property ports so that assertions can be done on it
   */
  public NavigationListAssert<EndpointPort, EndpointPortAssert> ports()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<EndpointPort, EndpointPortAssert> assertFactory = new AssertFactory<EndpointPort, EndpointPortAssert>() {
      public EndpointPortAssert createAssert(EndpointPort t) {
        return (EndpointPortAssert) assertThat(t);
      }
    };
    NavigationListAssert<EndpointPort, EndpointPortAssert> answer = new NavigationListAssert<EndpointPort, EndpointPortAssert>(actual.getPorts(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "ports"));
    return answer;
  }


}
