package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link Duration} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractDurationAssert<S extends AbstractDurationAssert<S, A>, A extends Duration> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractDurationAssert}</code> to make assertions on actual Duration.
   * @param actual the Duration we want to make assertions on.
   */
  protected AbstractDurationAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property duration so that assertions can be done on it
   */
  public org.assertj.core.api.DurationAssert duration()  {
    // check that actual Duration we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.DurationAssert) assertThat(actual.getDuration()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "duration"));
  }


  /**
   * Verifies that the actual Duration's value is equal to the given one.
   * @param value the given value to compare the actual Duration's value to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Duration's value is not equal to the given one.
   */
  public S hasValue(Long value) {
    // check that actual Duration we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting value of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualValue = actual.getValue();
    if (!Objects.areEqual(actualValue, value)) {
      failWithMessage(assertjErrorMessage, actual, value, actualValue);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
