package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link DownwardAPIProjection} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractDownwardAPIProjectionAssert<S extends AbstractDownwardAPIProjectionAssert<S, A>, A extends DownwardAPIProjection> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractDownwardAPIProjectionAssert}</code> to make assertions on actual DownwardAPIProjection.
   * @param actual the DownwardAPIProjection we want to make assertions on.
   */
  protected AbstractDownwardAPIProjectionAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual DownwardAPIProjection we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property items so that assertions can be done on it
   */
  public NavigationListAssert<DownwardAPIVolumeFile, DownwardAPIVolumeFileAssert> items()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<DownwardAPIVolumeFile, DownwardAPIVolumeFileAssert> assertFactory = new AssertFactory<DownwardAPIVolumeFile, DownwardAPIVolumeFileAssert>() {
      public DownwardAPIVolumeFileAssert createAssert(DownwardAPIVolumeFile t) {
        return (DownwardAPIVolumeFileAssert) assertThat(t);
      }
    };
    NavigationListAssert<DownwardAPIVolumeFile, DownwardAPIVolumeFileAssert> answer = new NavigationListAssert<DownwardAPIVolumeFile, DownwardAPIVolumeFileAssert>(actual.getItems(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "items"));
    return answer;
  }


}
