package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link ContainerStatus} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractContainerStatusAssert<S extends AbstractContainerStatusAssert<S, A>, A extends ContainerStatus> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractContainerStatusAssert}</code> to make assertions on actual ContainerStatus.
   * @param actual the ContainerStatus we want to make assertions on.
   */
  protected AbstractContainerStatusAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual ContainerStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property containerID so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert containerID()  {
    // check that actual ContainerStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getContainerID()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "containerID"));
  }


  /**
   * Navigates to the property image so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert image()  {
    // check that actual ContainerStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getImage()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "image"));
  }


  /**
   * Navigates to the property imageID so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert imageID()  {
    // check that actual ContainerStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getImageID()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "imageID"));
  }


  /**
   * Navigates to the property lastState so that assertions can be done on it
   */
  public ContainerStateAssert lastState()  {
    // check that actual ContainerStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ContainerStateAssert) assertThat(actual.getLastState()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "lastState"));
  }


  /**
   * Navigates to the property name so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert name()  {
    // check that actual ContainerStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "name"));
  }


  /**
   * Navigates to the property ready so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert ready()  {
    // check that actual ContainerStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getReady()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "ready"));
  }


  /**
   * Verifies that the actual ContainerStatus's restartCount is equal to the given one.
   * @param restartCount the given restartCount to compare the actual ContainerStatus's restartCount to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerStatus's restartCount is not equal to the given one.
   */
  public S hasRestartCount(Integer restartCount) {
    // check that actual ContainerStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting restartCount of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualRestartCount = actual.getRestartCount();
    if (!Objects.areEqual(actualRestartCount, restartCount)) {
      failWithMessage(assertjErrorMessage, actual, restartCount, actualRestartCount);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property started so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert started()  {
    // check that actual ContainerStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getStarted()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "started"));
  }


  /**
   * Navigates to the property state so that assertions can be done on it
   */
  public ContainerStateAssert state()  {
    // check that actual ContainerStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ContainerStateAssert) assertThat(actual.getState()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "state"));
  }


}
