package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link ContainerState} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractContainerStateAssert<S extends AbstractContainerStateAssert<S, A>, A extends ContainerState> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractContainerStateAssert}</code> to make assertions on actual ContainerState.
   * @param actual the ContainerState we want to make assertions on.
   */
  protected AbstractContainerStateAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual ContainerState we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property running so that assertions can be done on it
   */
  public ContainerStateRunningAssert running()  {
    // check that actual ContainerState we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ContainerStateRunningAssert) assertThat(actual.getRunning()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "running"));
  }


  /**
   * Navigates to the property terminated so that assertions can be done on it
   */
  public ContainerStateTerminatedAssert terminated()  {
    // check that actual ContainerState we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ContainerStateTerminatedAssert) assertThat(actual.getTerminated()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "terminated"));
  }


  /**
   * Navigates to the property waiting so that assertions can be done on it
   */
  public ContainerStateWaitingAssert waiting()  {
    // check that actual ContainerState we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ContainerStateWaitingAssert) assertThat(actual.getWaiting()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "waiting"));
  }


}
