package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link ContainerPort} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractContainerPortAssert<S extends AbstractContainerPortAssert<S, A>, A extends ContainerPort> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractContainerPortAssert}</code> to make assertions on actual ContainerPort.
   * @param actual the ContainerPort we want to make assertions on.
   */
  protected AbstractContainerPortAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual ContainerPort we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Verifies that the actual ContainerPort's containerPort is equal to the given one.
   * @param containerPort the given containerPort to compare the actual ContainerPort's containerPort to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerPort's containerPort is not equal to the given one.
   */
  public S hasContainerPort(Integer containerPort) {
    // check that actual ContainerPort we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting containerPort of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualContainerPort = actual.getContainerPort();
    if (!Objects.areEqual(actualContainerPort, containerPort)) {
      failWithMessage(assertjErrorMessage, actual, containerPort, actualContainerPort);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property hostIP so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert hostIP()  {
    // check that actual ContainerPort we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getHostIP()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "hostIP"));
  }


  /**
   * Verifies that the actual ContainerPort's hostPort is equal to the given one.
   * @param hostPort the given hostPort to compare the actual ContainerPort's hostPort to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerPort's hostPort is not equal to the given one.
   */
  public S hasHostPort(Integer hostPort) {
    // check that actual ContainerPort we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting hostPort of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualHostPort = actual.getHostPort();
    if (!Objects.areEqual(actualHostPort, hostPort)) {
      failWithMessage(assertjErrorMessage, actual, hostPort, actualHostPort);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property name so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert name()  {
    // check that actual ContainerPort we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "name"));
  }


  /**
   * Navigates to the property protocol so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert protocol()  {
    // check that actual ContainerPort we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getProtocol()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "protocol"));
  }


}
