package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link ConfigMapNodeConfigSource} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractConfigMapNodeConfigSourceAssert<S extends AbstractConfigMapNodeConfigSourceAssert<S, A>, A extends ConfigMapNodeConfigSource> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractConfigMapNodeConfigSourceAssert}</code> to make assertions on actual ConfigMapNodeConfigSource.
   * @param actual the ConfigMapNodeConfigSource we want to make assertions on.
   */
  protected AbstractConfigMapNodeConfigSourceAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual ConfigMapNodeConfigSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property kubeletConfigKey so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert kubeletConfigKey()  {
    // check that actual ConfigMapNodeConfigSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getKubeletConfigKey()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "kubeletConfigKey"));
  }


  /**
   * Navigates to the property name so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert name()  {
    // check that actual ConfigMapNodeConfigSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "name"));
  }


  /**
   * Navigates to the property namespace so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert namespace()  {
    // check that actual ConfigMapNodeConfigSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getNamespace()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "namespace"));
  }


  /**
   * Navigates to the property resourceVersion so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert resourceVersion()  {
    // check that actual ConfigMapNodeConfigSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getResourceVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "resourceVersion"));
  }


  /**
   * Navigates to the property uid so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert uid()  {
    // check that actual ConfigMapNodeConfigSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getUid()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "uid"));
  }


}
