package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link Config} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractConfigAssert<S extends AbstractConfigAssert<S, A>, A extends Config> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractConfigAssert}</code> to make assertions on actual Config.
   * @param actual the Config we want to make assertions on.
   */
  protected AbstractConfigAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual Config we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property apiVersion so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert apiVersion()  {
    // check that actual Config we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getApiVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "apiVersion"));
  }


  /**
   * Navigates to the property clusters so that assertions can be done on it
   */
  public NavigationListAssert<NamedCluster, NamedClusterAssert> clusters()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<NamedCluster, NamedClusterAssert> assertFactory = new AssertFactory<NamedCluster, NamedClusterAssert>() {
      public NamedClusterAssert createAssert(NamedCluster t) {
        return (NamedClusterAssert) assertThat(t);
      }
    };
    NavigationListAssert<NamedCluster, NamedClusterAssert> answer = new NavigationListAssert<NamedCluster, NamedClusterAssert>(actual.getClusters(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "clusters"));
    return answer;
  }


  /**
   * Navigates to the property contexts so that assertions can be done on it
   */
  public NavigationListAssert<NamedContext, NamedContextAssert> contexts()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<NamedContext, NamedContextAssert> assertFactory = new AssertFactory<NamedContext, NamedContextAssert>() {
      public NamedContextAssert createAssert(NamedContext t) {
        return (NamedContextAssert) assertThat(t);
      }
    };
    NavigationListAssert<NamedContext, NamedContextAssert> answer = new NavigationListAssert<NamedContext, NamedContextAssert>(actual.getContexts(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "contexts"));
    return answer;
  }


  /**
   * Navigates to the property currentContext so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert currentContext()  {
    // check that actual Config we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getCurrentContext()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "currentContext"));
  }


  /**
   * Navigates to the property extensions so that assertions can be done on it
   */
  public NavigationListAssert<NamedExtension, NamedExtensionAssert> extensions()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<NamedExtension, NamedExtensionAssert> assertFactory = new AssertFactory<NamedExtension, NamedExtensionAssert>() {
      public NamedExtensionAssert createAssert(NamedExtension t) {
        return (NamedExtensionAssert) assertThat(t);
      }
    };
    NavigationListAssert<NamedExtension, NamedExtensionAssert> answer = new NavigationListAssert<NamedExtension, NamedExtensionAssert>(actual.getExtensions(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "extensions"));
    return answer;
  }


  /**
   * Navigates to the property kind so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert kind()  {
    // check that actual Config we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getKind()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "kind"));
  }


  /**
   * Navigates to the property preferences so that assertions can be done on it
   */
  public PreferencesAssert preferences()  {
    // check that actual Config we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (PreferencesAssert) assertThat(actual.getPreferences()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "preferences"));
  }


  /**
   * Navigates to the property users so that assertions can be done on it
   */
  public NavigationListAssert<NamedAuthInfo, NamedAuthInfoAssert> users()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<NamedAuthInfo, NamedAuthInfoAssert> assertFactory = new AssertFactory<NamedAuthInfo, NamedAuthInfoAssert>() {
      public NamedAuthInfoAssert createAssert(NamedAuthInfo t) {
        return (NamedAuthInfoAssert) assertThat(t);
      }
    };
    NavigationListAssert<NamedAuthInfo, NamedAuthInfoAssert> answer = new NavigationListAssert<NamedAuthInfo, NamedAuthInfoAssert>(actual.getUsers(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "users"));
    return answer;
  }


}
