package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link Cluster} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractClusterAssert<S extends AbstractClusterAssert<S, A>, A extends Cluster> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractClusterAssert}</code> to make assertions on actual Cluster.
   * @param actual the Cluster we want to make assertions on.
   */
  protected AbstractClusterAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual Cluster we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property certificateAuthority so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert certificateAuthority()  {
    // check that actual Cluster we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getCertificateAuthority()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "certificateAuthority"));
  }


  /**
   * Navigates to the property certificateAuthorityData so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert certificateAuthorityData()  {
    // check that actual Cluster we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getCertificateAuthorityData()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "certificateAuthorityData"));
  }


  /**
   * Navigates to the property extensions so that assertions can be done on it
   */
  public NavigationListAssert<NamedExtension, NamedExtensionAssert> extensions()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<NamedExtension, NamedExtensionAssert> assertFactory = new AssertFactory<NamedExtension, NamedExtensionAssert>() {
      public NamedExtensionAssert createAssert(NamedExtension t) {
        return (NamedExtensionAssert) assertThat(t);
      }
    };
    NavigationListAssert<NamedExtension, NamedExtensionAssert> answer = new NavigationListAssert<NamedExtension, NamedExtensionAssert>(actual.getExtensions(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "extensions"));
    return answer;
  }


  /**
   * Navigates to the property insecureSkipTlsVerify so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert insecureSkipTlsVerify()  {
    // check that actual Cluster we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getInsecureSkipTlsVerify()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "insecureSkipTlsVerify"));
  }


  /**
   * Navigates to the property server so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert server()  {
    // check that actual Cluster we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getServer()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "server"));
  }


}
