package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link ClientIPConfig} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractClientIPConfigAssert<S extends AbstractClientIPConfigAssert<S, A>, A extends ClientIPConfig> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractClientIPConfigAssert}</code> to make assertions on actual ClientIPConfig.
   * @param actual the ClientIPConfig we want to make assertions on.
   */
  protected AbstractClientIPConfigAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual ClientIPConfig we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Verifies that the actual ClientIPConfig's timeoutSeconds is equal to the given one.
   * @param timeoutSeconds the given timeoutSeconds to compare the actual ClientIPConfig's timeoutSeconds to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ClientIPConfig's timeoutSeconds is not equal to the given one.
   */
  public S hasTimeoutSeconds(Integer timeoutSeconds) {
    // check that actual ClientIPConfig we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting timeoutSeconds of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualTimeoutSeconds = actual.getTimeoutSeconds();
    if (!Objects.areEqual(actualTimeoutSeconds, timeoutSeconds)) {
      failWithMessage(assertjErrorMessage, actual, timeoutSeconds, actualTimeoutSeconds);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
