package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link CSIVolumeSource} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractCSIVolumeSourceAssert<S extends AbstractCSIVolumeSourceAssert<S, A>, A extends CSIVolumeSource> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractCSIVolumeSourceAssert}</code> to make assertions on actual CSIVolumeSource.
   * @param actual the CSIVolumeSource we want to make assertions on.
   */
  protected AbstractCSIVolumeSourceAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual CSIVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property driver so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert driver()  {
    // check that actual CSIVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getDriver()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "driver"));
  }


  /**
   * Navigates to the property fsType so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert fsType()  {
    // check that actual CSIVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getFsType()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "fsType"));
  }


  /**
   * Navigates to the property nodePublishSecretRef so that assertions can be done on it
   */
  public LocalObjectReferenceAssert nodePublishSecretRef()  {
    // check that actual CSIVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (LocalObjectReferenceAssert) assertThat(actual.getNodePublishSecretRef()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "nodePublishSecretRef"));
  }


  /**
   * Navigates to the property readOnly so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert readOnly()  {
    // check that actual CSIVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getReadOnly()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "readOnly"));
  }


  /**
   * Navigates to the property volumeAttributes so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert volumeAttributes()  {
    // check that actual CSIVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getVolumeAttributes()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "volumeAttributes"));
  }


}
