package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link AuthInfo} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractAuthInfoAssert<S extends AbstractAuthInfoAssert<S, A>, A extends AuthInfo> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractAuthInfoAssert}</code> to make assertions on actual AuthInfo.
   * @param actual the AuthInfo we want to make assertions on.
   */
  protected AbstractAuthInfoAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual AuthInfo we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property as so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert as()  {
    // check that actual AuthInfo we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getAs()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "as"));
  }


  /**
   * Navigates to the property asGroups so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> asGroups()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getAsGroups(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "asGroups"));
    return answer;
  }


  /**
   * Navigates to the property asUserExtra so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert asUserExtra()  {
    // check that actual AuthInfo we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAsUserExtra()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "asUserExtra"));
  }


  /**
   * Navigates to the property authProvider so that assertions can be done on it
   */
  public AuthProviderConfigAssert authProvider()  {
    // check that actual AuthInfo we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (AuthProviderConfigAssert) assertThat(actual.getAuthProvider()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "authProvider"));
  }


  /**
   * Navigates to the property clientCertificate so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert clientCertificate()  {
    // check that actual AuthInfo we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getClientCertificate()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "clientCertificate"));
  }


  /**
   * Navigates to the property clientCertificateData so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert clientCertificateData()  {
    // check that actual AuthInfo we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getClientCertificateData()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "clientCertificateData"));
  }


  /**
   * Navigates to the property clientKey so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert clientKey()  {
    // check that actual AuthInfo we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getClientKey()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "clientKey"));
  }


  /**
   * Navigates to the property clientKeyData so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert clientKeyData()  {
    // check that actual AuthInfo we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getClientKeyData()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "clientKeyData"));
  }


  /**
   * Navigates to the property exec so that assertions can be done on it
   */
  public ExecConfigAssert exec()  {
    // check that actual AuthInfo we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ExecConfigAssert) assertThat(actual.getExec()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "exec"));
  }


  /**
   * Navigates to the property extensions so that assertions can be done on it
   */
  public NavigationListAssert<NamedExtension, NamedExtensionAssert> extensions()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<NamedExtension, NamedExtensionAssert> assertFactory = new AssertFactory<NamedExtension, NamedExtensionAssert>() {
      public NamedExtensionAssert createAssert(NamedExtension t) {
        return (NamedExtensionAssert) assertThat(t);
      }
    };
    NavigationListAssert<NamedExtension, NamedExtensionAssert> answer = new NavigationListAssert<NamedExtension, NamedExtensionAssert>(actual.getExtensions(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "extensions"));
    return answer;
  }


  /**
   * Navigates to the property password so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert password()  {
    // check that actual AuthInfo we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getPassword()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "password"));
  }


  /**
   * Navigates to the property token so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert token()  {
    // check that actual AuthInfo we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getToken()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "token"));
  }


  /**
   * Navigates to the property tokenFile so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert tokenFile()  {
    // check that actual AuthInfo we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getTokenFile()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "tokenFile"));
  }


  /**
   * Navigates to the property username so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert username()  {
    // check that actual AuthInfo we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getUsername()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "username"));
  }


}
