package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link APIGroupList} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractAPIGroupListAssert<S extends AbstractAPIGroupListAssert<S, A>, A extends APIGroupList> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractAPIGroupListAssert}</code> to make assertions on actual APIGroupList.
   * @param actual the APIGroupList we want to make assertions on.
   */
  protected AbstractAPIGroupListAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual APIGroupList we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property apiVersion so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert apiVersion()  {
    // check that actual APIGroupList we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getApiVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "apiVersion"));
  }


  /**
   * Navigates to the property groups so that assertions can be done on it
   */
  public NavigationListAssert<APIGroup, APIGroupAssert> groups()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<APIGroup, APIGroupAssert> assertFactory = new AssertFactory<APIGroup, APIGroupAssert>() {
      public APIGroupAssert createAssert(APIGroup t) {
        return (APIGroupAssert) assertThat(t);
      }
    };
    NavigationListAssert<APIGroup, APIGroupAssert> answer = new NavigationListAssert<APIGroup, APIGroupAssert>(actual.getGroups(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "groups"));
    return answer;
  }


  /**
   * Navigates to the property kind so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert kind()  {
    // check that actual APIGroupList we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getKind()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "kind"));
  }


}
